/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.utils;

import java.util.Locale;
import java.util.stream.Stream;

public class Os {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    public static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.ENGLISH);
    public static final String OS_FAMILY;
    public static final boolean IS_WINDOWS;
    private static final String FAMILY_WINDOWS = "windows";
    private static final String FAMILY_WIN9X = "win9x";
    public static final String FAMILY_NT = "winnt";
    private static final String FAMILY_OS2 = "os/2";
    private static final String FAMILY_NETWARE = "netware";
    private static final String FAMILY_DOS = "dos";
    private static final String FAMILY_MAC = "mac";
    private static final String FAMILY_TANDEM = "tandem";
    private static final String FAMILY_UNIX = "unix";
    private static final String FAMILY_OPENVMS = "openvms";
    private static final String FAMILY_ZOS = "z/os";
    private static final String FAMILY_OS390 = "os/390";
    private static final String FAMILY_OS400 = "os/400";
    private static final String DARWIN = "darwin";
    private static final String PATH_SEP;

    private Os() {
    }

    public static boolean isFamily(String family) {
        return Os.isFamily(family, OS_NAME);
    }

    public static boolean isFamily(String family, String actualOsName) {
        boolean isWindows = actualOsName.contains(FAMILY_WINDOWS);
        boolean is9x = false;
        boolean isNT = false;
        if (isWindows) {
            is9x = actualOsName.contains("95") || actualOsName.contains("98") || actualOsName.contains("me") || actualOsName.contains("ce");
            isNT = !is9x;
        }
        switch (family) {
            case "windows": {
                return isWindows;
            }
            case "win9x": {
                return isWindows && is9x;
            }
            case "winnt": {
                return isWindows && isNT;
            }
            case "os/2": {
                return actualOsName.contains(FAMILY_OS2);
            }
            case "netware": {
                return actualOsName.contains(FAMILY_NETWARE);
            }
            case "dos": {
                return PATH_SEP.equals(";") && !Os.isFamily(FAMILY_NETWARE, actualOsName) && !isWindows;
            }
            case "mac": {
                return actualOsName.contains(FAMILY_MAC) || actualOsName.contains(DARWIN);
            }
            case "tandem": {
                return actualOsName.contains("nonstop_kernel");
            }
            case "unix": {
                return PATH_SEP.equals(":") && !Os.isFamily(FAMILY_OPENVMS, actualOsName) && (!Os.isFamily(FAMILY_MAC, actualOsName) || actualOsName.endsWith("x"));
            }
            case "z/os": {
                return actualOsName.contains(FAMILY_ZOS) || actualOsName.contains(FAMILY_OS390);
            }
            case "os/400": {
                return actualOsName.contains(FAMILY_OS400);
            }
            case "openvms": {
                return actualOsName.contains(FAMILY_OPENVMS);
            }
        }
        return actualOsName.contains(family.toLowerCase(Locale.US));
    }

    private static String getOsFamily() {
        return Stream.of(FAMILY_DOS, FAMILY_MAC, FAMILY_NETWARE, FAMILY_NT, FAMILY_OPENVMS, FAMILY_OS2, FAMILY_OS400, FAMILY_TANDEM, FAMILY_UNIX, FAMILY_WIN9X, FAMILY_WINDOWS, FAMILY_ZOS).filter(Os::isFamily).findFirst().orElse(null);
    }

    static {
        PATH_SEP = System.getProperty("path.separator");
        OS_FAMILY = Os.getOsFamily();
        IS_WINDOWS = Os.isFamily(FAMILY_WINDOWS);
    }
}

