/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.toolchain.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.maven.toolchain.io.ToolchainsParseException;
import org.jetbrains.kotlin.org.apache.maven.toolchain.io.ToolchainsReader;
import org.jetbrains.kotlin.org.apache.maven.toolchain.model.PersistedToolchains;
import org.jetbrains.kotlin.org.apache.maven.toolchain.model.io.xpp3.MavenToolchainsXpp3Reader;
import org.jetbrains.kotlin.org.codehaus.plexus.util.ReaderFactory;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named
@Singleton
public class DefaultToolchainsReader
implements ToolchainsReader {
    @Override
    public PersistedToolchains read(File input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        return this.read(ReaderFactory.newXmlReader(input), options);
    }

    @Override
    public PersistedToolchains read(Reader input, Map<String, ?> options) throws IOException {
        PersistedToolchains persistedToolchains;
        block8: {
            Objects.requireNonNull(input, "input cannot be null");
            Reader in = input;
            try {
                persistedToolchains = new MavenToolchainsXpp3Reader().read(in, this.isStrict(options));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XmlPullParserException e) {
                    throw new ToolchainsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
                }
            }
            in.close();
        }
        return persistedToolchains;
    }

    @Override
    public PersistedToolchains read(InputStream input, Map<String, ?> options) throws IOException {
        PersistedToolchains persistedToolchains;
        block8: {
            Objects.requireNonNull(input, "input cannot be null");
            InputStream in = input;
            try {
                persistedToolchains = new MavenToolchainsXpp3Reader().read(in, this.isStrict(options));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XmlPullParserException e) {
                    throw new ToolchainsParseException(e.getMessage(), e.getLineNumber(), e.getColumnNumber(), e);
                }
            }
            in.close();
        }
        return persistedToolchains;
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("org.jetbrains.kotlin.org.apache.maven.toolchains.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

