/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.shared.utils.xml;

import java.io.IOException;
import java.io.Writer;

final class XMLEncode {
    private static final int CDATA_BLOCK_THRESHOLD_LENGTH = 12;
    private static final char DEFAULT_QUOTE_CHAR = '\"';

    XMLEncode() {
    }

    static void xmlEncodeText(String text, Writer writer) throws IOException {
        String cdata;
        if (text == null) {
            return;
        }
        if (!XMLEncode.needsEncoding(text)) {
            writer.write(text);
            return;
        }
        if (text.length() > 12 && (cdata = XMLEncode.xmlEncodeTextAsCDATABlock(text)) != null) {
            writer.write(cdata);
            return;
        }
        XMLEncode.xmlEncodeTextAsPCDATA(text, false, '\"', writer);
    }

    static void xmlEncodeTextAsPCDATA(String text, boolean forAttribute, char quoteChar, Writer n) throws IOException {
        if (text == null) {
            return;
        }
        int length = text.length();
        if (forAttribute) {
            n.append(quoteChar);
        }
        block9: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    n.append("&amp;");
                    continue block9;
                }
                case '<': {
                    n.append("&lt;");
                    continue block9;
                }
                case '>': {
                    n.append("&gt;");
                    continue block9;
                }
                case '\"': {
                    if (forAttribute) {
                        n.append("&quot;");
                        continue block9;
                    }
                    n.append(c);
                    continue block9;
                }
                case '\'': {
                    if (forAttribute) {
                        n.append("&apos;");
                        continue block9;
                    }
                    n.append(c);
                    continue block9;
                }
                case '\r': {
                    if (forAttribute) {
                        if (i != length - 1 && text.charAt(i + 1) == '\n') continue block9;
                        n.append("&#13;");
                        continue block9;
                    }
                    n.append(c);
                    continue block9;
                }
                case '\n': {
                    if (!forAttribute) continue block9;
                    n.append("&#10;");
                    continue block9;
                }
                default: {
                    n.append(c);
                }
            }
        }
        if (forAttribute) {
            n.append(quoteChar);
        }
    }

    private static String xmlEncodeTextAsCDATABlock(String text) {
        if (text == null) {
            return null;
        }
        if (!text.contains("]]>")) {
            return "<![CDATA[" + text + "]]>";
        }
        return null;
    }

    private static boolean needsEncoding(String text) {
        if (text == null) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != '&' && c != '<') continue;
            return true;
        }
        return false;
    }
}

