/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.session.scope.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.OutOfScopeException;
import org.jetbrains.kotlin.com.google.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.Scope;

public class SessionScope
implements Scope {
    private static final Provider<Object> SEEDED_KEY_PROVIDER = () -> {
        throw new IllegalStateException();
    };
    private final List<ScopeState> values = new CopyOnWriteArrayList<ScopeState>();

    public void enter() {
        this.values.add(0, new ScopeState());
    }

    protected ScopeState getScopeState() {
        if (this.values.isEmpty()) {
            throw new OutOfScopeException("Cannot access session scope outside of a scoping block");
        }
        return this.values.get(0);
    }

    public void exit() {
        if (this.values.isEmpty()) {
            throw new IllegalStateException();
        }
        this.values.remove(0);
    }

    public <T> void seed(Class<T> clazz, Provider<T> value) {
        this.getScopeState().seed(clazz, value);
    }

    public <T> void seed(Class<T> clazz, T value) {
        this.seed(clazz, (T)((Provider<Object>)() -> value));
    }

    @Override
    public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
        return () -> this.getScopeState().scope(key, unscoped).get();
    }

    public static <T> Provider<T> seededKeyProvider() {
        return SEEDED_KEY_PROVIDER;
    }

    protected static final class ScopeState {
        private final Map<Key<?>, CachingProvider<?>> provided = new ConcurrentHashMap();

        protected ScopeState() {
        }

        public <T> void seed(Class<T> clazz, Provider<T> value) {
            this.provided.put(Key.get(clazz), new CachingProvider<T>(value));
        }

        public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
            Provider provider = this.provided.computeIfAbsent(key, k -> new CachingProvider(unscoped));
            return provider;
        }

        public Collection<CachingProvider<?>> providers() {
            return this.provided.values();
        }
    }

    protected static class CachingProvider<T>
    implements Provider<T> {
        private final Provider<T> provider;
        private volatile T value;

        CachingProvider(Provider<T> provider) {
            this.provider = provider;
        }

        public T value() {
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.value == null) {
                CachingProvider cachingProvider = this;
                synchronized (cachingProvider) {
                    if (this.value == null) {
                        this.value = this.provider.get();
                    }
                }
            }
            return this.value;
        }
    }
}

