/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.repository.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.VersionsMetadata;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.deployment.DeployRequest;
import org.jetbrains.kotlin.org.eclipse.aether.impl.MetadataGenerator;
import org.jetbrains.kotlin.org.eclipse.aether.installation.InstallRequest;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;

class VersionsMetadataGenerator
implements MetadataGenerator {
    private final Map<Object, VersionsMetadata> versions = new LinkedHashMap<Object, VersionsMetadata>();
    private final Map<Object, VersionsMetadata> processedVersions = new LinkedHashMap<Object, VersionsMetadata>();
    private final Date timestamp;

    VersionsMetadataGenerator(RepositorySystemSession session, InstallRequest request) {
        this(session, request.getMetadata());
    }

    VersionsMetadataGenerator(RepositorySystemSession session, DeployRequest request) {
        this(session, request.getMetadata());
    }

    private VersionsMetadataGenerator(RepositorySystemSession session, Collection<? extends Metadata> metadatas) {
        this.timestamp = (Date)ConfigUtils.getObject(session, (Object)new Date(), "maven.startTime");
        Iterator<? extends Metadata> it = metadatas.iterator();
        while (it.hasNext()) {
            Metadata metadata = it.next();
            if (!(metadata instanceof VersionsMetadata)) continue;
            it.remove();
            VersionsMetadata versionsMetadata = (VersionsMetadata)metadata;
            this.processedVersions.put(versionsMetadata.getKey(), versionsMetadata);
        }
    }

    @Override
    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }

    @Override
    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    @Override
    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            VersionsMetadata versionsMetadata;
            Object key = VersionsMetadata.getKey(artifact);
            if (this.processedVersions.get(key) != null || (versionsMetadata = this.versions.get(key)) != null) continue;
            versionsMetadata = new VersionsMetadata(artifact, this.timestamp);
            this.versions.put(key, versionsMetadata);
        }
        return this.versions.values();
    }
}

