/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.repository.internal;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.AbstractArtifact;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;

public final class RelocatedArtifact
extends AbstractArtifact {
    private final Artifact artifact;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String message;

    RelocatedArtifact(Artifact artifact, String groupId, String artifactId, String version, String message) {
        this.artifact = Objects.requireNonNull(artifact, "artifact cannot be null");
        this.groupId = groupId != null && groupId.length() > 0 ? groupId : null;
        this.artifactId = artifactId != null && artifactId.length() > 0 ? artifactId : null;
        this.version = version != null && version.length() > 0 ? version : null;
        this.message = message != null && message.length() > 0 ? message : null;
    }

    @Override
    public String getGroupId() {
        if (this.groupId != null) {
            return this.groupId;
        }
        return this.artifact.getGroupId();
    }

    @Override
    public String getArtifactId() {
        if (this.artifactId != null) {
            return this.artifactId;
        }
        return this.artifact.getArtifactId();
    }

    @Override
    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return this.artifact.getVersion();
    }

    @Override
    public Artifact setVersion(String version) {
        String current = this.getVersion();
        if (current.equals(version) || version == null && current.length() <= 0) {
            return this;
        }
        return new RelocatedArtifact(this.artifact, this.groupId, this.artifactId, version, this.message);
    }

    @Override
    public Artifact setFile(File file) {
        File current = this.getFile();
        if (Objects.equals(current, file)) {
            return this;
        }
        return new RelocatedArtifact(this.artifact.setFile(file), this.groupId, this.artifactId, this.version, this.message);
    }

    @Override
    public Artifact setProperties(Map<String, String> properties) {
        Map<String, String> current = this.getProperties();
        if (current.equals(properties) || properties == null && current.isEmpty()) {
            return this;
        }
        return new RelocatedArtifact(this.artifact.setProperties(properties), this.groupId, this.artifactId, this.version, this.message);
    }

    @Override
    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    @Override
    public String getExtension() {
        return this.artifact.getExtension();
    }

    @Override
    public File getFile() {
        return this.artifact.getFile();
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.artifact.getProperty(key, defaultValue);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.artifact.getProperties();
    }

    public String getMessage() {
        return this.message;
    }
}

