/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.project;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblem;
import org.jetbrains.kotlin.org.apache.maven.project.DependencyResolutionResult;
import org.jetbrains.kotlin.org.apache.maven.project.MavenProject;
import org.jetbrains.kotlin.org.apache.maven.project.ProjectBuildingResult;

class DefaultProjectBuildingResult
implements ProjectBuildingResult {
    private String projectId;
    private File pomFile;
    private MavenProject project;
    private List<ModelProblem> problems;
    private DependencyResolutionResult dependencyResolutionResult;

    DefaultProjectBuildingResult(MavenProject project, List<ModelProblem> problems, DependencyResolutionResult dependencyResolutionResult) {
        this.projectId = project != null ? project.getGroupId() + ':' + project.getArtifactId() + ':' + project.getVersion() : "";
        this.pomFile = project != null ? project.getFile() : null;
        this.project = project;
        this.problems = problems;
        this.dependencyResolutionResult = dependencyResolutionResult;
    }

    DefaultProjectBuildingResult(String projectId, File pomFile, List<ModelProblem> problems) {
        this.projectId = projectId != null ? projectId : "";
        this.pomFile = pomFile;
        this.problems = problems;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public File getPomFile() {
        return this.pomFile;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public List<ModelProblem> getProblems() {
        if (this.problems == null) {
            this.problems = new ArrayList<ModelProblem>();
        }
        return this.problems;
    }

    @Override
    public DependencyResolutionResult getDependencyResolutionResult() {
        return this.dependencyResolutionResult;
    }
}

