/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.plugin.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.maven.execution.MavenSession;
import org.jetbrains.kotlin.org.apache.maven.plugin.PluginValidationManager;
import org.jetbrains.kotlin.org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.jetbrains.kotlin.org.apache.maven.plugin.descriptor.Parameter;
import org.jetbrains.kotlin.org.apache.maven.plugin.internal.AbstractMavenPluginDescriptorSourcedParametersValidator;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.PlexusConfiguration;

@Named
@Singleton
class ReadOnlyPluginParametersValidator
extends AbstractMavenPluginDescriptorSourcedParametersValidator {
    @Inject
    ReadOnlyPluginParametersValidator(PluginValidationManager pluginValidationManager) {
        super(pluginValidationManager);
    }

    @Override
    protected String getParameterLogReason(Parameter parameter) {
        return "is read-only, must not be used in configuration";
    }

    @Override
    protected void doValidate(MavenSession mavenSession, MojoDescriptor mojoDescriptor, Class<?> mojoClass, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        if (mojoDescriptor.getParameters() == null) {
            return;
        }
        mojoDescriptor.getParameters().stream().filter(parameter -> !parameter.isEditable()).forEach(parameter -> this.checkParameter(mavenSession, mojoDescriptor, mojoClass, (Parameter)parameter, pomConfiguration, expressionEvaluator));
    }

    private void checkParameter(MavenSession mavenSession, MojoDescriptor mojoDescriptor, Class<?> mojoClass, Parameter parameter, PlexusConfiguration pomConfiguration, ExpressionEvaluator expressionEvaluator) {
        PlexusConfiguration config = pomConfiguration.getChild(parameter.getName(), false);
        if (this.isValueSet(config, expressionEvaluator)) {
            this.pluginValidationManager.reportPluginMojoValidationIssue(PluginValidationManager.IssueLocality.INTERNAL, mavenSession, mojoDescriptor, mojoClass, this.formatParameter(parameter));
        }
    }
}

