/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.plugin.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.maven.plugin.PluginValidationManager;
import org.jetbrains.kotlin.org.apache.maven.plugin.internal.AbstractMavenPluginDependenciesValidator;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorResult;

@Singleton
@Named
class PlexusContainerDefaultDependenciesValidator
extends AbstractMavenPluginDependenciesValidator {
    @Inject
    PlexusContainerDefaultDependenciesValidator(PluginValidationManager pluginValidationManager) {
        super(pluginValidationManager);
    }

    @Override
    protected void doValidate(RepositorySystemSession session, Artifact pluginArtifact, ArtifactDescriptorResult artifactDescriptorResult) {
        boolean pcdPresent = artifactDescriptorResult.getDependencies().stream().filter(d -> "org.jetbrains.kotlin.org.codehaus.plexus".equals(d.getArtifact().getGroupId())).anyMatch(d -> "plexus-container-default".equals(d.getArtifact().getArtifactId()));
        if (pcdPresent) {
            this.pluginValidationManager.reportPluginValidationIssue(PluginValidationManager.IssueLocality.EXTERNAL, session, pluginArtifact, "Plugin depends on plexus-container-default, which is EOL");
        }
    }
}

