/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.plugin.internal;

import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.maven.plugin.PluginValidationManager;
import org.jetbrains.kotlin.org.apache.maven.plugin.internal.AbstractMavenPluginDependenciesValidator;
import org.jetbrains.kotlin.org.apache.maven.plugin.internal.DefaultPluginValidationManager;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.graph.Dependency;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorResult;

@Singleton
@Named
class Maven2DependenciesValidator
extends AbstractMavenPluginDependenciesValidator {
    @Inject
    Maven2DependenciesValidator(PluginValidationManager pluginValidationManager) {
        super(pluginValidationManager);
    }

    @Override
    protected void doValidate(RepositorySystemSession session, Artifact pluginArtifact, ArtifactDescriptorResult artifactDescriptorResult) {
        Set maven2Versions = artifactDescriptorResult.getDependencies().stream().map(Dependency::getArtifact).filter(d -> "org.jetbrains.kotlin.org.apache.maven".equals(d.getGroupId())).filter(d -> !DefaultPluginValidationManager.EXPECTED_PROVIDED_SCOPE_EXCLUSIONS_GA.contains(d.getGroupId() + ":" + d.getArtifactId())).map(Artifact::getVersion).filter(v -> v.startsWith("2.")).collect(Collectors.toSet());
        if (!maven2Versions.isEmpty()) {
            this.pluginValidationManager.reportPluginValidationIssue(PluginValidationManager.IssueLocality.EXTERNAL, session, pluginArtifact, "Plugin is a Maven 2.x plugin, which will be not supported in Maven 4.x");
        }
    }
}

