/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.plugin.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.maven.eventspy.AbstractEventSpy;
import org.jetbrains.kotlin.org.apache.maven.execution.ExecutionEvent;
import org.jetbrains.kotlin.org.apache.maven.execution.MavenSession;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocation;
import org.jetbrains.kotlin.org.apache.maven.plugin.PluginValidationManager;
import org.jetbrains.kotlin.org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.jetbrains.kotlin.org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public final class DefaultPluginValidationManager
extends AbstractEventSpy
implements PluginValidationManager {
    static final Collection<String> EXPECTED_PROVIDED_SCOPE_EXCLUSIONS_GA = Collections.unmodifiableCollection(Arrays.asList("org.jetbrains.kotlin.org.apache.maven:maven-archiver", "org.jetbrains.kotlin.org.apache.maven:maven-jxr", "org.jetbrains.kotlin.org.apache.maven:plexus-utils"));
    private static final String ISSUES_KEY = DefaultPluginValidationManager.class.getName() + ".issues";
    private static final String PLUGIN_EXCLUDES_KEY = DefaultPluginValidationManager.class.getName() + ".excludes";
    private static final String MAVEN_PLUGIN_VALIDATION_KEY = "maven.plugin.validation";
    private static final String MAVEN_PLUGIN_VALIDATION_EXCLUDES_KEY = "maven.plugin.validation.excludes";
    private static final ValidationReportLevel DEFAULT_VALIDATION_LEVEL = ValidationReportLevel.INLINE;
    private static final Collection<ValidationReportLevel> INLINE_VALIDATION_LEVEL = Collections.unmodifiableCollection(Arrays.asList(ValidationReportLevel.INLINE, ValidationReportLevel.BRIEF));
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void onEvent(Object event) {
        if (event instanceof ExecutionEvent) {
            ExecutionEvent executionEvent = (ExecutionEvent)event;
            if (executionEvent.getType() == ExecutionEvent.Type.SessionStarted) {
                RepositorySystemSession repositorySystemSession = executionEvent.getSession().getRepositorySession();
                this.validationReportLevel(repositorySystemSession);
                this.validationPluginExcludes(repositorySystemSession);
            } else if (executionEvent.getType() == ExecutionEvent.Type.SessionEnded) {
                this.reportSessionCollectedValidationIssues(executionEvent.getSession());
            }
        }
    }

    private List<?> validationPluginExcludes(RepositorySystemSession session) {
        return (List)session.getData().computeIfAbsent(PLUGIN_EXCLUDES_KEY, () -> this.parsePluginExcludes(session));
    }

    private List<String> parsePluginExcludes(RepositorySystemSession session) {
        String excludes = ConfigUtils.getString(session, null, MAVEN_PLUGIN_VALIDATION_EXCLUDES_KEY);
        if (excludes == null || excludes.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(excludes.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private ValidationReportLevel validationReportLevel(RepositorySystemSession session) {
        return (ValidationReportLevel)((Object)session.getData().computeIfAbsent(ValidationReportLevel.class, () -> this.parseValidationReportLevel(session)));
    }

    private ValidationReportLevel parseValidationReportLevel(RepositorySystemSession session) {
        String level = ConfigUtils.getString(session, null, MAVEN_PLUGIN_VALIDATION_KEY);
        if (level == null || level.isEmpty()) {
            return DEFAULT_VALIDATION_LEVEL;
        }
        try {
            return ValidationReportLevel.valueOf(level.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Invalid value specified for property {}: '{}'. Supported values are (case insensitive): {}", MAVEN_PLUGIN_VALIDATION_KEY, level, Arrays.toString((Object[])ValidationReportLevel.values()));
            return DEFAULT_VALIDATION_LEVEL;
        }
    }

    private String pluginKey(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    private String pluginKey(MojoDescriptor mojoDescriptor) {
        PluginDescriptor pd = mojoDescriptor.getPluginDescriptor();
        return this.pluginKey(pd.getGroupId(), pd.getArtifactId(), pd.getVersion());
    }

    private String pluginKey(Artifact pluginArtifact) {
        return this.pluginKey(pluginArtifact.getGroupId(), pluginArtifact.getArtifactId(), pluginArtifact.getVersion());
    }

    private void mayReportInline(RepositorySystemSession session, PluginValidationManager.IssueLocality locality, String issue) {
        ValidationReportLevel validationReportLevel;
        if (locality == PluginValidationManager.IssueLocality.INTERNAL && INLINE_VALIDATION_LEVEL.contains((Object)(validationReportLevel = this.validationReportLevel(session)))) {
            this.logger.warn(" {}", (Object)issue);
        }
    }

    @Override
    public void reportPluginValidationIssue(PluginValidationManager.IssueLocality locality, RepositorySystemSession session, Artifact pluginArtifact, String issue) {
        String pluginKey = this.pluginKey(pluginArtifact);
        if (this.validationPluginExcludes(session).contains(pluginKey)) {
            return;
        }
        PluginValidationIssues pluginIssues = this.pluginIssues(session).computeIfAbsent(pluginKey, k -> new PluginValidationIssues());
        pluginIssues.reportPluginIssue(locality, null, issue);
        this.mayReportInline(session, locality, issue);
    }

    @Override
    public void reportPluginValidationIssue(PluginValidationManager.IssueLocality locality, MavenSession mavenSession, MojoDescriptor mojoDescriptor, String issue) {
        String pluginKey = this.pluginKey(mojoDescriptor);
        if (this.validationPluginExcludes(mavenSession.getRepositorySession()).contains(pluginKey)) {
            return;
        }
        PluginValidationIssues pluginIssues = this.pluginIssues(mavenSession.getRepositorySession()).computeIfAbsent(pluginKey, k -> new PluginValidationIssues());
        pluginIssues.reportPluginIssue(locality, this.pluginDeclaration(mavenSession, mojoDescriptor), issue);
        this.mayReportInline(mavenSession.getRepositorySession(), locality, issue);
    }

    @Override
    public void reportPluginMojoValidationIssue(PluginValidationManager.IssueLocality locality, MavenSession mavenSession, MojoDescriptor mojoDescriptor, Class<?> mojoClass, String issue) {
        String pluginKey = this.pluginKey(mojoDescriptor);
        if (this.validationPluginExcludes(mavenSession.getRepositorySession()).contains(pluginKey)) {
            return;
        }
        PluginValidationIssues pluginIssues = this.pluginIssues(mavenSession.getRepositorySession()).computeIfAbsent(pluginKey, k -> new PluginValidationIssues());
        pluginIssues.reportPluginMojoIssue(locality, this.pluginDeclaration(mavenSession, mojoDescriptor), this.mojoInfo(mojoDescriptor, mojoClass), issue);
        this.mayReportInline(mavenSession.getRepositorySession(), locality, issue);
    }

    private void reportSessionCollectedValidationIssues(MavenSession mavenSession) {
        EnumSet<PluginValidationManager.IssueLocality> issueLocalitiesToReport;
        if (!this.logger.isWarnEnabled()) {
            return;
        }
        ValidationReportLevel validationReportLevel = this.validationReportLevel(mavenSession.getRepositorySession());
        if (validationReportLevel == ValidationReportLevel.NONE || validationReportLevel == ValidationReportLevel.INLINE) {
            return;
        }
        ConcurrentHashMap<String, PluginValidationIssues> issuesMap = this.pluginIssues(mavenSession.getRepositorySession());
        EnumSet<PluginValidationManager.IssueLocality> enumSet = issueLocalitiesToReport = validationReportLevel == ValidationReportLevel.SUMMARY || validationReportLevel == ValidationReportLevel.VERBOSE ? EnumSet.allOf(PluginValidationManager.IssueLocality.class) : EnumSet.of(PluginValidationManager.IssueLocality.EXTERNAL);
        if (this.hasAnythingToReport(issuesMap, issueLocalitiesToReport)) {
            this.logger.warn("");
            this.logger.warn("Plugin {} validation issues were detected in following plugin(s)", (Object)issueLocalitiesToReport);
            this.logger.warn("");
            ArrayList<Map.Entry<String, PluginValidationIssues>> sortedEntries = new ArrayList<Map.Entry<String, PluginValidationIssues>>(issuesMap.entrySet());
            sortedEntries.sort(Map.Entry.comparingByKey(String.CASE_INSENSITIVE_ORDER));
            for (Map.Entry entry : sortedEntries) {
                PluginValidationIssues issues = (PluginValidationIssues)entry.getValue();
                if (!this.hasAnythingToReport(issues, issueLocalitiesToReport)) continue;
                this.logger.warn(" * {}", entry.getKey());
                if (validationReportLevel != ValidationReportLevel.VERBOSE) continue;
                if (!issues.pluginDeclarations.isEmpty()) {
                    this.logger.warn("  Declared at location(s):");
                    for (String pluginDeclaration : issues.pluginDeclarations) {
                        this.logger.warn("   * {}", (Object)pluginDeclaration);
                    }
                }
                if (!issues.pluginIssues.isEmpty()) {
                    for (PluginValidationManager.IssueLocality issueLocality : issueLocalitiesToReport) {
                        Set pluginIssues = (Set)issues.pluginIssues.get((Object)issueLocality);
                        if (pluginIssues == null || pluginIssues.isEmpty()) continue;
                        this.logger.warn("  Plugin {} issue(s):", (Object)issueLocality);
                        for (String pluginIssue : pluginIssues) {
                            this.logger.warn("   * {}", (Object)pluginIssue);
                        }
                    }
                }
                if (!issues.mojoIssues.isEmpty()) {
                    for (PluginValidationManager.IssueLocality issueLocality : issueLocalitiesToReport) {
                        Map mojoIssues = (Map)issues.mojoIssues.get((Object)issueLocality);
                        if (mojoIssues == null || mojoIssues.isEmpty()) continue;
                        this.logger.warn("  Mojo {} issue(s):", (Object)issueLocality);
                        for (String mojoInfo : mojoIssues.keySet()) {
                            this.logger.warn("   * Mojo {}", (Object)mojoInfo);
                            for (String mojoIssue : (LinkedHashSet)mojoIssues.get(mojoInfo)) {
                                this.logger.warn("     - {}", (Object)mojoIssue);
                            }
                        }
                    }
                }
                this.logger.warn("");
            }
            this.logger.warn("");
            if (validationReportLevel == ValidationReportLevel.VERBOSE) {
                this.logger.warn("Fix reported issues by adjusting plugin configuration or by upgrading above listed plugins. If no upgrade available, please notify plugin maintainers about reported issues.");
            }
            this.logger.warn("For more or less details, use 'maven.plugin.validation' property with one of the values (case insensitive): {}", (Object)Arrays.toString((Object[])ValidationReportLevel.values()));
            this.logger.warn("");
        }
    }

    private boolean hasAnythingToReport(Map<String, PluginValidationIssues> issuesMap, EnumSet<PluginValidationManager.IssueLocality> issueLocalitiesToReport) {
        for (PluginValidationIssues issues : issuesMap.values()) {
            if (!this.hasAnythingToReport(issues, issueLocalitiesToReport)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnythingToReport(PluginValidationIssues issues, EnumSet<PluginValidationManager.IssueLocality> issueLocalitiesToReport) {
        for (PluginValidationManager.IssueLocality issueLocality : issueLocalitiesToReport) {
            Set pluginIssues = (Set)issues.pluginIssues.get((Object)issueLocality);
            if (pluginIssues != null && !pluginIssues.isEmpty()) {
                return true;
            }
            Map mojoIssues = (Map)issues.mojoIssues.get((Object)issueLocality);
            if (mojoIssues == null || mojoIssues.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private String pluginDeclaration(MavenSession mavenSession, MojoDescriptor mojoDescriptor) {
        InputLocation inputLocation = mojoDescriptor.getPluginDescriptor().getPlugin().getLocation("");
        if (inputLocation != null && inputLocation.getSource() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(inputLocation.getSource().getModelId());
            String location = inputLocation.getSource().getLocation();
            if (location != null) {
                if (location.contains("://")) {
                    stringBuilder.append(" (").append(location).append(")");
                } else {
                    Path topLevelBasedir = mavenSession.getTopLevelProject().getBasedir().toPath();
                    Path locationPath = new File(location).toPath().toAbsolutePath().normalize();
                    if (locationPath.startsWith(topLevelBasedir)) {
                        locationPath = topLevelBasedir.relativize(locationPath);
                    }
                    stringBuilder.append(" (").append(locationPath).append(")");
                }
            }
            stringBuilder.append(" @ line ").append(inputLocation.getLineNumber());
            return stringBuilder.toString();
        }
        return "unknown";
    }

    private String mojoInfo(MojoDescriptor mojoDescriptor, Class<?> mojoClass) {
        return mojoDescriptor.getFullGoalName() + " (" + mojoClass.getName() + ")";
    }

    private ConcurrentHashMap<String, PluginValidationIssues> pluginIssues(RepositorySystemSession session) {
        return (ConcurrentHashMap)session.getData().computeIfAbsent(ISSUES_KEY, ConcurrentHashMap::new);
    }

    private static enum ValidationReportLevel {
        NONE,
        INLINE,
        SUMMARY,
        BRIEF,
        VERBOSE;

    }

    private static class PluginValidationIssues {
        private final LinkedHashSet<String> pluginDeclarations = new LinkedHashSet();
        private final HashMap<PluginValidationManager.IssueLocality, LinkedHashSet<String>> pluginIssues = new HashMap();
        private final HashMap<PluginValidationManager.IssueLocality, LinkedHashMap<String, LinkedHashSet<String>>> mojoIssues = new HashMap();

        private PluginValidationIssues() {
        }

        private synchronized void reportPluginIssue(PluginValidationManager.IssueLocality issueLocality, String pluginDeclaration, String issue) {
            if (pluginDeclaration != null) {
                this.pluginDeclarations.add(pluginDeclaration);
            }
            this.pluginIssues.computeIfAbsent(issueLocality, k -> new LinkedHashSet()).add(issue);
        }

        private synchronized void reportPluginMojoIssue(PluginValidationManager.IssueLocality issueLocality, String pluginDeclaration, String mojoInfo, String issue) {
            if (pluginDeclaration != null) {
                this.pluginDeclarations.add(pluginDeclaration);
            }
            this.mojoIssues.computeIfAbsent(issueLocality, k -> new LinkedHashMap()).computeIfAbsent(mojoInfo, k -> new LinkedHashSet()).add(issue);
        }
    }
}

