/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.plugin.descriptor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.kotlin.org.apache.maven.plugin.Mojo;
import org.jetbrains.kotlin.org.apache.maven.plugin.descriptor.DuplicateParameterException;
import org.jetbrains.kotlin.org.apache.maven.plugin.descriptor.Parameter;
import org.jetbrains.kotlin.org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.jetbrains.kotlin.org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;

public class MojoDescriptor
extends ComponentDescriptor<Mojo>
implements Cloneable {
    public static final String MAVEN_PLUGIN = "maven-plugin";
    public static final String SINGLE_PASS_EXEC_STRATEGY = "once-per-session";
    public static final String MULTI_PASS_EXEC_STRATEGY = "always";
    private static final String DEFAULT_INSTANTIATION_STRATEGY = "per-lookup";
    private static final String DEFAULT_LANGUAGE = "java";
    private final ArrayList<Parameter> parameters = new ArrayList();
    private String executionStrategy = "once-per-session";
    private String goal;
    private String phase;
    private String since;
    private String executePhase;
    private String executeGoal;
    private String executeLifecycle;
    private String deprecated;
    private boolean aggregator = false;
    private String dependencyResolutionRequired = null;
    private String dependencyCollectionRequired;
    private boolean projectRequired = true;
    private boolean onlineRequired = false;
    private PlexusConfiguration mojoConfiguration;
    private PluginDescriptor pluginDescriptor;
    private boolean inheritedByDefault = true;
    private boolean directInvocationOnly = false;
    private boolean requiresReports = false;
    private boolean threadSafe = false;

    public MojoDescriptor() {
        this.setInstantiationStrategy(DEFAULT_INSTANTIATION_STRATEGY);
        this.setComponentFactory(DEFAULT_LANGUAGE);
    }

    public String getLanguage() {
        return this.getComponentFactory();
    }

    public void setLanguage(String language) {
        this.setComponentFactory(language);
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(String deprecated) {
        this.deprecated = deprecated;
    }

    public List<Parameter> getParameters() {
        return new ArrayList<Parameter>(this.parameters);
    }

    public void setParameters(List<Parameter> parameters) throws DuplicateParameterException {
        this.parameters.clear();
        for (Parameter parameter : parameters) {
            this.addParameter(parameter);
        }
    }

    public void addParameter(Parameter parameter) throws DuplicateParameterException {
        if (this.parameters.contains(parameter)) {
            throw new DuplicateParameterException(parameter.getName() + " has been declared multiple times in mojo with goal: " + this.getGoal() + " (implementation: " + this.getImplementation() + ")");
        }
        this.parameters.add(parameter);
    }

    public Map<String, Parameter> getParameterMap() {
        LinkedHashMap<String, Parameter> parameterMap = new LinkedHashMap<String, Parameter>();
        for (Parameter pd : this.parameters) {
            parameterMap.put(pd.getName(), pd);
        }
        return parameterMap;
    }

    public void setDependencyResolutionRequired(String requiresDependencyResolution) {
        this.dependencyResolutionRequired = requiresDependencyResolution;
    }

    public String getDependencyResolutionRequired() {
        return this.dependencyResolutionRequired;
    }

    @Deprecated
    public String isDependencyResolutionRequired() {
        return this.dependencyResolutionRequired;
    }

    public void setDependencyCollectionRequired(String requiresDependencyCollection) {
        this.dependencyCollectionRequired = requiresDependencyCollection;
    }

    public String getDependencyCollectionRequired() {
        return this.dependencyCollectionRequired;
    }

    public void setProjectRequired(boolean requiresProject) {
        this.projectRequired = requiresProject;
    }

    public boolean isProjectRequired() {
        return this.projectRequired;
    }

    public void setOnlineRequired(boolean requiresOnline) {
        this.onlineRequired = requiresOnline;
    }

    public boolean isOnlineRequired() {
        return this.onlineRequired;
    }

    public boolean requiresOnline() {
        return this.onlineRequired;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getSince() {
        return this.since;
    }

    public void setSince(String since) {
        this.since = since;
    }

    public String getGoal() {
        return this.goal;
    }

    public void setGoal(String goal) {
        this.goal = goal;
    }

    public String getExecutePhase() {
        return this.executePhase;
    }

    public void setExecutePhase(String executePhase) {
        this.executePhase = executePhase;
    }

    public boolean alwaysExecute() {
        return MULTI_PASS_EXEC_STRATEGY.equals(this.executionStrategy);
    }

    public String getExecutionStrategy() {
        return this.executionStrategy;
    }

    public void setExecutionStrategy(String executionStrategy) {
        this.executionStrategy = executionStrategy;
    }

    public PlexusConfiguration getMojoConfiguration() {
        if (this.mojoConfiguration == null) {
            this.mojoConfiguration = new XmlPlexusConfiguration("configuration");
        }
        return this.mojoConfiguration;
    }

    public void setMojoConfiguration(PlexusConfiguration mojoConfiguration) {
        this.mojoConfiguration = mojoConfiguration;
    }

    @Override
    public String getRole() {
        return Mojo.ROLE;
    }

    @Override
    public String getRoleHint() {
        return this.getId();
    }

    public String getId() {
        return this.getPluginDescriptor().getId() + ":" + this.getGoal();
    }

    public String getFullGoalName() {
        return this.getPluginDescriptor().getGoalPrefix() + ":" + this.getGoal();
    }

    @Override
    public String getComponentType() {
        return MAVEN_PLUGIN;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.pluginDescriptor = pluginDescriptor;
    }

    public boolean isInheritedByDefault() {
        return this.inheritedByDefault;
    }

    public void setInheritedByDefault(boolean inheritedByDefault) {
        this.inheritedByDefault = inheritedByDefault;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MojoDescriptor) {
            MojoDescriptor other = (MojoDescriptor)object;
            return Objects.equals(this.getPluginDescriptor(), other.getPluginDescriptor()) && Objects.equals(this.getGoal(), other.getGoal());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getGoal(), this.getPluginDescriptor());
    }

    public String getExecuteLifecycle() {
        return this.executeLifecycle;
    }

    public void setExecuteLifecycle(String executeLifecycle) {
        this.executeLifecycle = executeLifecycle;
    }

    public void setAggregator(boolean aggregator) {
        this.aggregator = aggregator;
    }

    public boolean isAggregator() {
        return this.aggregator;
    }

    public boolean isDirectInvocationOnly() {
        return this.directInvocationOnly;
    }

    public void setDirectInvocationOnly(boolean directInvocationOnly) {
        this.directInvocationOnly = directInvocationOnly;
    }

    public boolean isRequiresReports() {
        return this.requiresReports;
    }

    public void setRequiresReports(boolean requiresReports) {
        this.requiresReports = requiresReports;
    }

    public void setExecuteGoal(String executeGoal) {
        this.executeGoal = executeGoal;
    }

    public String getExecuteGoal() {
        return this.executeGoal;
    }

    public boolean isThreadSafe() {
        return this.threadSafe;
    }

    public void setThreadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public boolean isForking() {
        return this.getExecuteGoal() != null && this.getExecuteGoal().length() > 0 || this.getExecutePhase() != null && this.getExecutePhase().length() > 0;
    }

    public MojoDescriptor clone() {
        try {
            return (MojoDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

