/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.builder.multithreaded;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.kotlin.org.apache.maven.execution.ProjectDependencyGraph;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.ProjectSegment;
import org.jetbrains.kotlin.org.apache.maven.project.MavenProject;

public class ConcurrencyDependencyGraph {
    private final ProjectBuildList projectBuilds;
    private final ProjectDependencyGraph projectDependencyGraph;
    private final Set<MavenProject> finishedProjects = new HashSet<MavenProject>();

    public ConcurrencyDependencyGraph(ProjectBuildList projectBuilds, ProjectDependencyGraph projectDependencyGraph) {
        this.projectDependencyGraph = projectDependencyGraph;
        this.projectBuilds = projectBuilds;
    }

    public int getNumberOfBuilds() {
        return this.projectBuilds.size();
    }

    public List<MavenProject> getRootSchedulableBuilds() {
        LinkedHashSet<MavenProject> result = new LinkedHashSet<MavenProject>();
        for (ProjectSegment projectBuild : this.projectBuilds) {
            if (!this.projectDependencyGraph.getUpstreamProjects(projectBuild.getProject(), false).isEmpty()) continue;
            result.add(projectBuild.getProject());
        }
        if (result.isEmpty() && this.projectBuilds.size() > 0) {
            result.add(this.projectBuilds.get(0).getProject());
        }
        return new ArrayList<MavenProject>(result);
    }

    public List<MavenProject> markAsFinished(MavenProject mavenProject) {
        this.finishedProjects.add(mavenProject);
        return this.getSchedulableNewProcesses(mavenProject);
    }

    private List<MavenProject> getSchedulableNewProcesses(MavenProject finishedProject) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject dependentProject : this.projectDependencyGraph.getDownstreamProjects(finishedProject, false)) {
            List<MavenProject> upstreamProjects = this.projectDependencyGraph.getUpstreamProjects(dependentProject, false);
            if (!this.finishedProjects.containsAll(upstreamProjects)) continue;
            result.add(dependentProject);
        }
        return result;
    }

    public Set<MavenProject> getUnfinishedProjects() {
        HashSet<MavenProject> unfinished = new HashSet<MavenProject>(this.projectBuilds.getProjects());
        unfinished.removeAll(this.finishedProjects);
        return unfinished;
    }

    protected Set<MavenProject> getFinishedProjects() {
        return this.finishedProjects;
    }

    protected ProjectBuildList getProjectBuilds() {
        return this.projectBuilds;
    }

    protected List<MavenProject> getDependencies(MavenProject p) {
        return this.projectDependencyGraph.getUpstreamProjects(p, false);
    }

    public List<MavenProject> getActiveDependencies(MavenProject p) {
        List<MavenProject> activeDependencies = this.projectDependencyGraph.getUpstreamProjects(p, false);
        activeDependencies.removeAll(this.finishedProjects);
        return activeDependencies;
    }
}

