/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.internal.aether;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.kotlin.org.apache.maven.model.Model;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.MavenWorkspaceReader;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.repository.WorkspaceReader;
import org.jetbrains.kotlin.org.eclipse.aether.repository.WorkspaceRepository;
import org.jetbrains.kotlin.org.eclipse.aether.util.repository.ChainedWorkspaceReader;

public final class MavenChainedWorkspaceReader
implements MavenWorkspaceReader {
    private ChainedWorkspaceReader delegate;
    private WorkspaceReader[] readers;

    private MavenChainedWorkspaceReader(WorkspaceReader ... readers) {
        this.delegate = new ChainedWorkspaceReader(readers);
        this.readers = readers;
    }

    @Override
    public Model findModel(Artifact artifact) {
        for (WorkspaceReader workspaceReader : this.readers) {
            Model model;
            if (!(workspaceReader instanceof MavenWorkspaceReader) || (model = ((MavenWorkspaceReader)workspaceReader).findModel(artifact)) == null) continue;
            return model;
        }
        return null;
    }

    @Override
    public WorkspaceRepository getRepository() {
        return this.delegate.getRepository();
    }

    @Override
    public File findArtifact(Artifact artifact) {
        return this.delegate.findArtifact(artifact);
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        return this.delegate.findVersions(artifact);
    }

    public static WorkspaceReader of(Collection<WorkspaceReader> workspaceReaderCollection) {
        WorkspaceReader[] readers = workspaceReaderCollection.toArray(new WorkspaceReader[0]);
        if (readers.length == 1) {
            return readers[0];
        }
        return new MavenChainedWorkspaceReader(readers);
    }
}

