/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.kotlin.org.apache.maven.execution.ProjectDependencyGraph;
import org.jetbrains.kotlin.org.apache.maven.project.DuplicateProjectException;
import org.jetbrains.kotlin.org.apache.maven.project.MavenProject;
import org.jetbrains.kotlin.org.apache.maven.project.ProjectSorter;
import org.jetbrains.kotlin.org.codehaus.plexus.util.dag.CycleDetectedException;

public class DefaultProjectDependencyGraph
implements ProjectDependencyGraph {
    private final ProjectSorter sorter;
    private final List<MavenProject> allProjects;
    private final Map<MavenProject, Integer> order;
    private final Map<String, MavenProject> projects;

    public DefaultProjectDependencyGraph(Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this.allProjects = Collections.unmodifiableList(new ArrayList<MavenProject>(projects));
        this.sorter = new ProjectSorter(projects);
        List<MavenProject> sorted = this.sorter.getSortedProjects();
        this.order = new HashMap<MavenProject, Integer>(sorted.size());
        this.projects = new HashMap<String, MavenProject>(sorted.size());
        int index = 0;
        for (MavenProject project : sorted) {
            String id = ProjectSorter.getId(project);
            this.projects.put(id, project);
            this.order.put(project, index++);
        }
    }

    public DefaultProjectDependencyGraph(List<MavenProject> allProjects, Collection<MavenProject> projects) throws CycleDetectedException, DuplicateProjectException {
        this.allProjects = Collections.unmodifiableList(new ArrayList<MavenProject>(allProjects));
        this.sorter = new ProjectSorter(projects);
        List<MavenProject> sorted = this.sorter.getSortedProjects();
        this.order = new HashMap<MavenProject, Integer>(sorted.size());
        this.projects = new HashMap<String, MavenProject>(sorted.size());
        int index = 0;
        for (MavenProject project : sorted) {
            String id = ProjectSorter.getId(project);
            this.projects.put(id, project);
            this.order.put(project, index++);
        }
    }

    @Override
    public List<MavenProject> getAllProjects() {
        return this.allProjects;
    }

    @Override
    public List<MavenProject> getSortedProjects() {
        return new ArrayList<MavenProject>(this.sorter.getSortedProjects());
    }

    @Override
    public List<MavenProject> getDownstreamProjects(MavenProject project, boolean transitive) {
        Objects.requireNonNull(project, "project cannot be null");
        HashSet<String> projectIds = new HashSet<String>();
        this.getDownstreamProjects(ProjectSorter.getId(project), projectIds, transitive);
        return this.getSortedProjects(projectIds);
    }

    private void getDownstreamProjects(String projectId, Set<String> projectIds, boolean transitive) {
        for (String id : this.sorter.getDependents(projectId)) {
            if (!projectIds.add(id) || !transitive) continue;
            this.getDownstreamProjects(id, projectIds, transitive);
        }
    }

    @Override
    public List<MavenProject> getUpstreamProjects(MavenProject project, boolean transitive) {
        Objects.requireNonNull(project, "project cannot be null");
        HashSet<String> projectIds = new HashSet<String>();
        this.getUpstreamProjects(ProjectSorter.getId(project), projectIds, transitive);
        return this.getSortedProjects(projectIds);
    }

    private void getUpstreamProjects(String projectId, Collection<String> projectIds, boolean transitive) {
        for (String id : this.sorter.getDependencies(projectId)) {
            if (!projectIds.add(id) || !transitive) continue;
            this.getUpstreamProjects(id, projectIds, transitive);
        }
    }

    private List<MavenProject> getSortedProjects(Set<String> projectIds) {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>(projectIds.size());
        for (String projectId : projectIds) {
            result.add(this.projects.get(projectId));
        }
        Collections.sort(result, new MavenProjectComparator());
        return result;
    }

    public String toString() {
        return this.sorter.getSortedProjects().toString();
    }

    private class MavenProjectComparator
    implements Comparator<MavenProject> {
        private MavenProjectComparator() {
        }

        @Override
        public int compare(MavenProject o1, MavenProject o2) {
            return (Integer)DefaultProjectDependencyGraph.this.order.get(o1) - (Integer)DefaultProjectDependencyGraph.this.order.get(o2);
        }
    }
}

