/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.extension.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.kotlin.org.apache.maven.extension.internal.CoreExtensionEntry;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm.ClassRealm;

public class CoreExports {
    private final Set<String> artifacts;
    private final Map<String, ClassLoader> packages;

    public CoreExports(CoreExtensionEntry entry) {
        this(entry.getClassRealm(), entry.getExportedArtifacts(), entry.getExportedPackages());
    }

    public CoreExports(ClassRealm realm, Set<String> exportedArtifacts, Set<String> exportedPackages) {
        this.artifacts = Collections.unmodifiableSet(new HashSet<String>(exportedArtifacts));
        this.packages = exportedPackages.stream().collect(Collectors.collectingAndThen(Collectors.toMap(Function.identity(), v -> realm), Collections::unmodifiableMap));
    }

    public Set<String> getExportedArtifacts() {
        return this.artifacts;
    }

    public Map<String, ClassLoader> getExportedPackages() {
        return this.packages;
    }
}

