/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.artifact.resolver.filter;

import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.kotlin.org.apache.maven.artifact.Artifact;
import org.jetbrains.kotlin.org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.jetbrains.kotlin.org.apache.maven.model.Exclusion;

public class ExclusionArtifactFilter
implements ArtifactFilter {
    private static final String WILDCARD = "*";
    private final List<Exclusion> exclusions;
    private Predicate<Exclusion> groupIdIsWildcard = exclusion -> WILDCARD.equals(exclusion.getGroupId());
    private Predicate<Exclusion> artifactIdIsWildcard = exclusion -> WILDCARD.equals(exclusion.getArtifactId());
    private Predicate<Exclusion> groupIdAndArtifactIdIsWildcard = this.groupIdIsWildcard.and(this.artifactIdIsWildcard);

    public ExclusionArtifactFilter(List<Exclusion> exclusions) {
        this.exclusions = exclusions;
    }

    private Predicate<Exclusion> sameArtifactId(Artifact artifact) {
        return exclusion -> exclusion.getArtifactId().equals(artifact.getArtifactId());
    }

    private Predicate<Exclusion> sameGroupId(Artifact artifact) {
        return exclusion -> exclusion.getGroupId().equals(artifact.getGroupId());
    }

    private Predicate<Exclusion> exclude(Artifact artifact) {
        return this.groupIdAndArtifactIdIsWildcard.or(this.groupIdIsWildcard.and(this.sameArtifactId(artifact))).or(this.artifactIdIsWildcard.and(this.sameGroupId(artifact))).or(this.sameGroupId(artifact).and(this.sameArtifactId(artifact)));
    }

    @Override
    public boolean include(Artifact artifact) {
        return !this.exclusions.stream().anyMatch(this.exclude(artifact));
    }
}

