/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.artifact.repository;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.kotlin.org.apache.maven.RepositoryUtils;
import org.jetbrains.kotlin.org.apache.maven.artifact.Artifact;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.ArtifactRepository;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.Authentication;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.jetbrains.kotlin.org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.jetbrains.kotlin.org.apache.maven.repository.Proxy;
import org.jetbrains.kotlin.org.apache.maven.repository.legacy.metadata.ArtifactMetadata;
import org.jetbrains.kotlin.org.eclipse.aether.DefaultRepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystem;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalArtifactRegistration;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalArtifactRequest;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalArtifactResult;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalMetadataRegistration;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalMetadataRequest;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalMetadataResult;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepositoryManager;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;

public class LegacyLocalRepositoryManager
implements LocalRepositoryManager {
    private final ArtifactRepository delegate;
    private final LocalRepository repo;
    private final boolean realLocalRepo;

    public static RepositorySystemSession overlay(ArtifactRepository repository, RepositorySystemSession session, RepositorySystem system) {
        if (repository == null || repository.getBasedir() == null) {
            return session;
        }
        if (session != null) {
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            if (lrm != null && lrm.getRepository().getBasedir().equals(new File(repository.getBasedir()))) {
                return session;
            }
        } else {
            session = new DefaultRepositorySystemSession();
        }
        LegacyLocalRepositoryManager llrm = new LegacyLocalRepositoryManager(repository);
        return new DefaultRepositorySystemSession(session).setLocalRepositoryManager(llrm);
    }

    private LegacyLocalRepositoryManager(ArtifactRepository delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate cannot be null");
        ArtifactRepositoryLayout layout = delegate.getLayout();
        this.repo = new LocalRepository(new File(delegate.getBasedir()), layout != null ? layout.getClass().getSimpleName() : "legacy");
        this.realLocalRepo = layout instanceof DefaultRepositoryLayout && "local".equals(delegate.getId());
    }

    @Override
    public LocalRepository getRepository() {
        return this.repo;
    }

    @Override
    public String getPathForLocalArtifact(org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact artifact) {
        if (this.realLocalRepo) {
            return this.delegate.pathOf(RepositoryUtils.toArtifact(artifact.setVersion(artifact.getBaseVersion())));
        }
        return this.delegate.pathOf(RepositoryUtils.toArtifact(artifact));
    }

    @Override
    public String getPathForRemoteArtifact(org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact artifact, RemoteRepository repository, String context) {
        return this.delegate.pathOf(RepositoryUtils.toArtifact(artifact));
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        return this.delegate.pathOfLocalRepositoryMetadata(new ArtifactMetadataAdapter(metadata), this.delegate);
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.delegate.pathOfLocalRepositoryMetadata(new ArtifactMetadataAdapter(metadata), new ArtifactRepositoryAdapter(repository));
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        String path = this.getPathForLocalArtifact(request.getArtifact());
        File file = new File(this.getRepository().getBasedir(), path);
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (file.isFile()) {
            result.setFile(file);
            result.setAvailable(true);
        }
        return result;
    }

    @Override
    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        Metadata metadata = request.getMetadata();
        String path = request.getRepository() == null ? this.getPathForLocalMetadata(metadata) : this.getPathForRemoteMetadata(metadata, request.getRepository(), request.getContext());
        File file = new File(this.getRepository().getBasedir(), path);
        LocalMetadataResult result = new LocalMetadataResult(request);
        if (file.isFile()) {
            result.setFile(file);
        }
        return result;
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
    }

    @Override
    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
    }

    static class ArtifactMetadataAdapter
    implements org.jetbrains.kotlin.org.apache.maven.artifact.metadata.ArtifactMetadata {
        private final Metadata metadata;

        ArtifactMetadataAdapter(Metadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public boolean storedInArtifactVersionDirectory() {
            return this.metadata.getVersion().length() > 0;
        }

        @Override
        public boolean storedInGroupDirectory() {
            return this.metadata.getArtifactId().length() <= 0;
        }

        @Override
        public String getGroupId() {
            return this.nullify(this.metadata.getGroupId());
        }

        @Override
        public String getArtifactId() {
            return this.nullify(this.metadata.getArtifactId());
        }

        @Override
        public String getBaseVersion() {
            return this.nullify(this.metadata.getVersion());
        }

        private String nullify(String str) {
            return str == null || str.length() <= 0 ? null : str;
        }

        @Override
        public Object getKey() {
            return this.metadata.toString();
        }

        @Override
        public String getRemoteFilename() {
            return this.metadata.getType();
        }

        @Override
        public String getLocalFilename(ArtifactRepository repository) {
            return this.insertRepositoryKey(this.getRemoteFilename(), repository.getKey());
        }

        private String insertRepositoryKey(String filename, String repositoryKey) {
            int idx = filename.indexOf(46);
            String result = idx < 0 ? filename + '-' + repositoryKey : filename.substring(0, idx) + '-' + repositoryKey + filename.substring(idx);
            return result;
        }

        @Override
        public void merge(ArtifactMetadata metadata) {
        }

        @Override
        public void merge(org.jetbrains.kotlin.org.apache.maven.artifact.metadata.ArtifactMetadata metadata) {
        }

        @Override
        public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataStoreException {
        }

        @Override
        public String extendedToString() {
            return this.metadata.toString();
        }
    }

    static class ArtifactRepositoryAdapter
    implements ArtifactRepository {
        private final RemoteRepository repository;

        ArtifactRepositoryAdapter(RemoteRepository repository) {
            this.repository = repository;
        }

        @Override
        public String pathOf(Artifact artifact) {
            return null;
        }

        @Override
        public String pathOfRemoteRepositoryMetadata(org.jetbrains.kotlin.org.apache.maven.artifact.metadata.ArtifactMetadata artifactMetadata) {
            return null;
        }

        @Override
        public String pathOfLocalRepositoryMetadata(org.jetbrains.kotlin.org.apache.maven.artifact.metadata.ArtifactMetadata metadata, ArtifactRepository repository) {
            return null;
        }

        @Override
        public String getUrl() {
            return this.repository.getUrl();
        }

        @Override
        public void setUrl(String url) {
        }

        @Override
        public String getBasedir() {
            return null;
        }

        @Override
        public String getProtocol() {
            return this.repository.getProtocol();
        }

        @Override
        public String getId() {
            return this.repository.getId();
        }

        @Override
        public void setId(String id) {
        }

        @Override
        public ArtifactRepositoryPolicy getSnapshots() {
            return null;
        }

        @Override
        public void setSnapshotUpdatePolicy(ArtifactRepositoryPolicy policy) {
        }

        @Override
        public ArtifactRepositoryPolicy getReleases() {
            return null;
        }

        @Override
        public void setReleaseUpdatePolicy(ArtifactRepositoryPolicy policy) {
        }

        @Override
        public ArtifactRepositoryLayout getLayout() {
            return null;
        }

        @Override
        public void setLayout(ArtifactRepositoryLayout layout) {
        }

        @Override
        public String getKey() {
            return this.getId();
        }

        @Override
        public boolean isUniqueVersion() {
            return true;
        }

        @Override
        public boolean isBlacklisted() {
            return false;
        }

        @Override
        public void setBlacklisted(boolean blackListed) {
        }

        @Override
        public Artifact find(Artifact artifact) {
            return null;
        }

        @Override
        public List<String> findVersions(Artifact artifact) {
            return Collections.emptyList();
        }

        @Override
        public boolean isProjectAware() {
            return false;
        }

        @Override
        public void setAuthentication(Authentication authentication) {
        }

        @Override
        public Authentication getAuthentication() {
            return null;
        }

        @Override
        public void setProxy(Proxy proxy) {
        }

        @Override
        public Proxy getProxy() {
            return null;
        }

        @Override
        public List<ArtifactRepository> getMirroredRepositories() {
            return Collections.emptyList();
        }

        @Override
        public void setMirroredRepositories(List<ArtifactRepository> mirroredRepositories) {
        }

        @Override
        public boolean isBlocked() {
            return false;
        }

        @Override
        public void setBlocked(boolean blocked) {
        }
    }
}

