/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.client.protocol;

import java.io.IOException;
import org.jetbrains.kotlin.org.apache.http.HttpEntity;
import org.jetbrains.kotlin.org.apache.http.HttpEntityEnclosingRequest;
import org.jetbrains.kotlin.org.apache.http.HttpException;
import org.jetbrains.kotlin.org.apache.http.HttpRequest;
import org.jetbrains.kotlin.org.apache.http.HttpRequestInterceptor;
import org.jetbrains.kotlin.org.apache.http.HttpVersion;
import org.jetbrains.kotlin.org.apache.http.ProtocolVersion;
import org.jetbrains.kotlin.org.apache.http.annotation.Contract;
import org.jetbrains.kotlin.org.apache.http.annotation.ThreadingBehavior;
import org.jetbrains.kotlin.org.apache.http.client.config.RequestConfig;
import org.jetbrains.kotlin.org.apache.http.client.protocol.HttpClientContext;
import org.jetbrains.kotlin.org.apache.http.protocol.HttpContext;
import org.jetbrains.kotlin.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

