/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.wire;

import java.util.Arrays;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.spi.Element;
import org.jetbrains.kotlin.com.google.inject.spi.Elements;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.ElementAnalyzer;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.FileTypeConverter;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.LocatorWiring;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.URLTypeConverter;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.Wiring;

public final class WireModule
implements Module {
    static final Module[] CONVERTERS = new Module[]{new FileTypeConverter(), new URLTypeConverter()};
    private final Iterable<Module> modules;
    private Strategy strategy = Strategy.DEFAULT;

    public WireModule(Module ... modules) {
        this(Arrays.asList(modules));
    }

    public WireModule(Iterable<Module> modules) {
        this.modules = modules;
    }

    public Module with(Strategy _strategy) {
        this.strategy = _strategy;
        return this;
    }

    @Override
    public void configure(Binder binder) {
        ElementAnalyzer analyzer = new ElementAnalyzer(binder);
        for (Element e : Elements.getElements(this.modules)) {
            e.acceptVisitor(analyzer);
        }
        analyzer.apply(this.strategy);
    }

    public static interface Strategy {
        public static final Strategy DEFAULT = new Strategy(){

            @Override
            public Wiring wiring(Binder binder) {
                Module[] moduleArray = CONVERTERS;
                int n = CONVERTERS.length;
                int n2 = 0;
                while (n2 < n) {
                    Module m3 = moduleArray[n2];
                    m3.configure(binder);
                    ++n2;
                }
                return new LocatorWiring(binder);
            }
        };

        public Wiring wiring(Binder var1);
    }
}

