/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.space;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.matcher.AbstractMatcher;
import org.jetbrains.kotlin.com.google.inject.spi.InjectionListener;
import org.jetbrains.kotlin.com.google.inject.spi.TypeEncounter;
import org.jetbrains.kotlin.com.google.inject.spi.TypeListener;
import org.jetbrains.kotlin.org.eclipse.sisu.Mediator;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.BeanLocator;

final class MediationListener
extends AbstractMatcher<TypeLiteral<?>>
implements TypeListener,
InjectionListener<Object> {
    private final List<Mediation<?, ?, ?>> mediation = new ArrayList();
    private final Provider<BeanLocator> locator;

    public MediationListener(Binder binder) {
        this.locator = binder.getProvider(BeanLocator.class);
    }

    public void mediate(Key key, Mediator mediator, Class watcherType) {
        this.mediation.add(new Mediation(key, mediator, watcherType));
    }

    @Override
    public boolean matches(TypeLiteral<?> type) {
        for (Mediation<?, ?, ?> m3 : this.mediation) {
            if (!m3.watcherType.isAssignableFrom(type.getRawType())) continue;
            return true;
        }
        return false;
    }

    public <T> void hear(TypeLiteral<T> type, TypeEncounter<T> encounter) {
        encounter.register(this);
    }

    @Override
    public void afterInjection(Object watcher) {
        for (Mediation<?, ?, ?> m3 : this.mediation) {
            if (!m3.watcherType.isInstance(watcher)) continue;
            this.locator.get().watch(m3.watchedKey, m3.mediator, watcher);
        }
    }

    private static final class Mediation<Q extends Annotation, T, W> {
        final Key<T> watchedKey;
        final Mediator<Q, T, W> mediator;
        final Class<W> watcherType;

        Mediation(Key<T> watchedKey, Mediator<Q, T, W> mediator, Class<W> watcherType) {
            this.watchedKey = watchedKey;
            this.mediator = mediator;
            this.watcherType = watcherType;
        }
    }
}

