/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static Object getObject(Map<?, ?> properties, Object defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (value == null) continue;
            return value;
        }
        return defaultValue;
    }

    public static Object getObject(RepositorySystemSession session, Object defaultValue, String ... keys) {
        return ConfigUtils.getObject(session.getConfigProperties(), defaultValue, keys);
    }

    public static String getString(Map<?, ?> properties, String defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (!(value instanceof String)) continue;
            return (String)value;
        }
        return defaultValue;
    }

    public static String getString(RepositorySystemSession session, String defaultValue, String ... keys) {
        return ConfigUtils.getString(session.getConfigProperties(), defaultValue, keys);
    }

    public static int getInteger(Map<?, ?> properties, int defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (!(value instanceof String)) continue;
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getInteger(RepositorySystemSession session, int defaultValue, String ... keys) {
        return ConfigUtils.getInteger(session.getConfigProperties(), defaultValue, keys);
    }

    public static long getLong(Map<?, ?> properties, long defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (!(value instanceof String)) continue;
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getLong(RepositorySystemSession session, long defaultValue, String ... keys) {
        return ConfigUtils.getLong(session.getConfigProperties(), defaultValue, keys);
    }

    public static float getFloat(Map<?, ?> properties, float defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            if (!(value instanceof String)) continue;
            try {
                return Float.parseFloat((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float getFloat(RepositorySystemSession session, float defaultValue, String ... keys) {
        return ConfigUtils.getFloat(session.getConfigProperties(), defaultValue, keys);
    }

    public static boolean getBoolean(Map<?, ?> properties, boolean defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (!(value instanceof String)) continue;
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public static boolean getBoolean(RepositorySystemSession session, boolean defaultValue, String ... keys) {
        return ConfigUtils.getBoolean(session.getConfigProperties(), defaultValue, keys);
    }

    public static List<?> getList(Map<?, ?> properties, List<?> defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (value instanceof List) {
                return (List)value;
            }
            if (!(value instanceof Collection)) continue;
            return Collections.unmodifiableList(new ArrayList((Collection)value));
        }
        return defaultValue;
    }

    public static List<?> getList(RepositorySystemSession session, List<?> defaultValue, String ... keys) {
        return ConfigUtils.getList(session.getConfigProperties(), defaultValue, keys);
    }

    public static Map<?, ?> getMap(Map<?, ?> properties, Map<?, ?> defaultValue, String ... keys) {
        for (String key : keys) {
            Object value = properties.get(key);
            if (!(value instanceof Map)) continue;
            return (Map)value;
        }
        return defaultValue;
    }

    public static Map<?, ?> getMap(RepositorySystemSession session, Map<?, ?> defaultValue, String ... keys) {
        return ConfigUtils.getMap(session.getConfigProperties(), defaultValue, keys);
    }

    public static List<String> parseCommaSeparatedNames(String commaSeparatedNames) {
        if (commaSeparatedNames == null || commaSeparatedNames.trim().isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.stream(commaSeparatedNames.split(",")).filter(s2 -> s2 != null && !s2.trim().isEmpty()).collect(Collectors.toList());
    }

    public static List<String> parseCommaSeparatedUniqueNames(String commaSeparatedNames) {
        return ConfigUtils.parseCommaSeparatedNames(commaSeparatedNames).stream().distinct().collect(Collectors.toList());
    }
}

