/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.SyncContext;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.jetbrains.kotlin.org.eclipse.aether.metadata.Metadata;
import org.jetbrains.kotlin.org.eclipse.aether.named.NamedLock;
import org.jetbrains.kotlin.org.eclipse.aether.named.NamedLockFactory;
import org.jetbrains.kotlin.org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamedLockFactoryAdapter {
    public static final String TIME_KEY = "aether.syncContext.named.time";
    public static final long DEFAULT_TIME = 30L;
    public static final String TIME_UNIT_KEY = "aether.syncContext.named.time.unit";
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    private final NameMapper nameMapper;
    private final NamedLockFactory namedLockFactory;

    public NamedLockFactoryAdapter(NameMapper nameMapper, NamedLockFactory namedLockFactory) {
        this.nameMapper = Objects.requireNonNull(nameMapper);
        this.namedLockFactory = Objects.requireNonNull(namedLockFactory);
        if (this.namedLockFactory instanceof FileLockNamedLockFactory && !this.nameMapper.isFileSystemFriendly()) {
            throw new IllegalArgumentException("Misconfiguration: FileLockNamedLockFactory lock factory requires FS friendly NameMapper");
        }
    }

    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        return new AdaptedLockSyncContext(session, shared, this.nameMapper, this.namedLockFactory);
    }

    public NameMapper getNameMapper() {
        return this.nameMapper;
    }

    public NamedLockFactory getNamedLockFactory() {
        return this.namedLockFactory;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(nameMapper=" + this.nameMapper + ", namedLockFactory=" + this.namedLockFactory + ")";
    }

    private static class AdaptedLockSyncContext
    implements SyncContext {
        private static final Logger LOGGER = LoggerFactory.getLogger(AdaptedLockSyncContext.class);
        private final RepositorySystemSession session;
        private final boolean shared;
        private final NameMapper lockNaming;
        private final NamedLockFactory namedLockFactory;
        private final long time;
        private final TimeUnit timeUnit;
        private final Deque<NamedLock> locks;

        private AdaptedLockSyncContext(RepositorySystemSession session, boolean shared, NameMapper lockNaming, NamedLockFactory namedLockFactory) {
            this.session = session;
            this.shared = shared;
            this.lockNaming = lockNaming;
            this.namedLockFactory = namedLockFactory;
            this.time = this.getTime(session);
            this.timeUnit = this.getTimeUnit(session);
            this.locks = new ArrayDeque<NamedLock>();
            if (this.time < 0L) {
                throw new IllegalArgumentException("time cannot be negative");
            }
        }

        private long getTime(RepositorySystemSession session) {
            return ConfigUtils.getLong(session, 30L, NamedLockFactoryAdapter.TIME_KEY);
        }

        private TimeUnit getTimeUnit(RepositorySystemSession session) {
            return TimeUnit.valueOf(ConfigUtils.getString(session, DEFAULT_TIME_UNIT.name(), NamedLockFactoryAdapter.TIME_UNIT_KEY));
        }

        @Override
        public void acquire(Collection<? extends Artifact> artifacts, Collection<? extends Metadata> metadatas) {
            Collection<String> keys = this.lockNaming.nameLocks(this.session, artifacts, metadatas);
            if (keys.isEmpty()) {
                return;
            }
            LOGGER.trace("Need {} {} lock(s) for {}", keys.size(), this.shared ? "read" : "write", keys);
            int acquiredLockCount = 0;
            for (String key : keys) {
                NamedLock namedLock = this.namedLockFactory.getLock(key);
                try {
                    LOGGER.trace("Acquiring {} lock for '{}'", (Object)(this.shared ? "read" : "write"), (Object)key);
                    boolean locked = this.shared ? namedLock.lockShared(this.time, this.timeUnit) : namedLock.lockExclusively(this.time, this.timeUnit);
                    if (!locked) {
                        LOGGER.trace("Failed to acquire {} lock for '{}'", (Object)(this.shared ? "read" : "write"), (Object)key);
                        namedLock.close();
                        throw new IllegalStateException("Could not acquire " + (this.shared ? "read" : "write") + " lock for '" + namedLock.name() + "'");
                    }
                    this.locks.push(namedLock);
                    ++acquiredLockCount;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
            LOGGER.trace("Total locks acquired: {}", (Object)acquiredLockCount);
        }

        @Override
        public void close() {
            if (this.locks.isEmpty()) {
                return;
            }
            int released = 0;
            while (!this.locks.isEmpty()) {
                NamedLock namedLock = this.locks.pop();
                try {
                    LOGGER.trace("Releasing {} lock for '{}'", (Object)(this.shared ? "read" : "write"), (Object)namedLock.name());
                    namedLock.unlock();
                    ++released;
                }
                finally {
                    if (namedLock == null) continue;
                    namedLock.close();
                }
            }
            LOGGER.trace("Total locks released: {}", (Object)released);
        }
    }
}

