/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.filter;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilterSource;
import org.jetbrains.kotlin.org.eclipse.aether.util.ConfigUtils;
import org.jetbrains.kotlin.org.eclipse.aether.util.DirectoryUtils;

public abstract class RemoteRepositoryFilterSourceSupport
implements RemoteRepositoryFilterSource {
    private static final String CONFIG_PROP_PREFIX = "aether.remoteRepositoryFilter.";
    private static final String CONF_NAME_BASEDIR = "basedir";
    static final String LOCAL_REPO_PREFIX_DIR = ".remoteRepositoryFilters";
    private final String name;

    protected RemoteRepositoryFilterSourceSupport(String name) {
        this.name = Objects.requireNonNull(name);
    }

    protected String configPropKey(String name) {
        return CONFIG_PROP_PREFIX + this.name + "." + name;
    }

    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONFIG_PROP_PREFIX + this.name);
    }

    protected Path getBasedir(RepositorySystemSession session, boolean mayCreate) {
        try {
            return DirectoryUtils.resolveDirectory(session, LOCAL_REPO_PREFIX_DIR, this.configPropKey(CONF_NAME_BASEDIR), mayCreate);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected static class SimpleResult
    implements RemoteRepositoryFilter.Result {
        private final boolean accepted;
        private final String reasoning;

        public SimpleResult(boolean accepted, String reasoning) {
            this.accepted = accepted;
            this.reasoning = Objects.requireNonNull(reasoning);
        }

        @Override
        public boolean isAccepted() {
            return this.accepted;
        }

        @Override
        public String reasoning() {
            return this.reasoning;
        }
    }
}

