/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.collect.bf;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyNode;
import org.jetbrains.kotlin.org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DependencyResolutionSkipper {
    DependencyResolutionSkipper() {
    }

    abstract boolean skipResolution(DependencyNode var1, List<DependencyNode> var2);

    abstract void cache(DependencyNode var1, List<DependencyNode> var2);

    abstract void report();

    public static DefaultDependencyResolutionSkipper defaultSkipper() {
        return new DefaultDependencyResolutionSkipper();
    }

    public static DependencyResolutionSkipper neverSkipper() {
        return NeverDependencyResolutionSkipper.INSTANCE;
    }

    static final class DefaultDependencyResolutionSkipper
    extends DependencyResolutionSkipper {
        private static final Logger LOGGER = LoggerFactory.getLogger(DependencyResolutionSkipper.class);
        private final Map<DependencyNode, DependencyResolutionResult> results = new LinkedHashMap<DependencyNode, DependencyResolutionResult>(256);
        private final CacheManager cacheManager = new CacheManager();
        private final CoordinateManager coordinateManager = new CoordinateManager();

        DefaultDependencyResolutionSkipper() {
        }

        @Override
        public boolean skipResolution(DependencyNode node, List<DependencyNode> parents) {
            DependencyResolutionResult result = new DependencyResolutionResult(node);
            this.results.put(node, result);
            int depth = parents.size() + 1;
            this.coordinateManager.createCoordinate(node, depth);
            if (this.cacheManager.isVersionConflict(node)) {
                result.skippedAsVersionConflict = true;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Skipped resolving node: {} as version conflict", (Object)ArtifactIdUtils.toId(node.getArtifact()));
                }
            } else if (this.cacheManager.isDuplicate(node)) {
                if (this.coordinateManager.isLeftmost(node, parents)) {
                    result.forceResolution = true;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Force resolving node: {} for scope selection", (Object)ArtifactIdUtils.toId(node.getArtifact()));
                    }
                } else {
                    result.skippedAsDuplicate = true;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Skipped resolving node: {} as duplicate", (Object)ArtifactIdUtils.toId(node.getArtifact()));
                    }
                }
            } else {
                result.resolve = true;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Resolving node: {}", (Object)ArtifactIdUtils.toId(node.getArtifact()));
                }
            }
            if (result.toResolve()) {
                this.coordinateManager.updateLeftmost(node);
                return false;
            }
            return true;
        }

        @Override
        public void cache(DependencyNode node, List<DependencyNode> parents) {
            boolean parentForceResolution = parents.stream().anyMatch(n -> this.results.containsKey(n) && this.results.get((Object)n).forceResolution);
            if (parentForceResolution) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Won't cache as node: {} inherits from a force-resolved node and will be omitted for duplicate", (Object)ArtifactIdUtils.toId(node.getArtifact()));
                }
            } else {
                this.cacheManager.cacheWinner(node);
            }
        }

        @Override
        public void report() {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Skipped {} nodes as duplicate", (Object)this.results.entrySet().stream().filter(n -> ((DependencyResolutionResult)n.getValue()).skippedAsDuplicate).count());
                LOGGER.trace("Skipped {} nodes as having version conflict", (Object)this.results.entrySet().stream().filter(n -> ((DependencyResolutionResult)n.getValue()).skippedAsVersionConflict).count());
                LOGGER.trace("Resolved {} nodes", (Object)this.results.entrySet().stream().filter(n -> ((DependencyResolutionResult)n.getValue()).resolve).count());
                LOGGER.trace("Forced resolving {} nodes for scope selection", (Object)this.results.entrySet().stream().filter(n -> ((DependencyResolutionResult)n.getValue()).forceResolution).count());
            }
        }

        public Map<DependencyNode, DependencyResolutionResult> getResults() {
            return this.results;
        }

        private static final class CacheManager {
            private final Map<Artifact, DependencyNode> winners = new HashMap<Artifact, DependencyNode>(256);
            private final Map<String, Artifact> winnerGAs = new HashMap<String, Artifact>(256);

            private CacheManager() {
            }

            boolean isVersionConflict(DependencyNode node) {
                String ga = ArtifactIdUtils.toVersionlessId(node.getArtifact());
                if (this.winnerGAs.containsKey(ga)) {
                    Artifact result = this.winnerGAs.get(ga);
                    return !node.getArtifact().getVersion().equals(result.getVersion());
                }
                return false;
            }

            void cacheWinner(DependencyNode node) {
                this.winners.put(node.getArtifact(), node);
                this.winnerGAs.put(ArtifactIdUtils.toVersionlessId(node.getArtifact()), node.getArtifact());
            }

            boolean isDuplicate(DependencyNode node) {
                return this.winners.containsKey(node.getArtifact());
            }
        }

        private static final class CoordinateManager {
            private final Map<Integer, AtomicInteger> sequenceGen = new HashMap<Integer, AtomicInteger>(256);
            private final Map<DependencyNode, Coordinate> coordinateMap = new HashMap<DependencyNode, Coordinate>(256);
            private final Map<Artifact, Coordinate> leftmostCoordinates = new HashMap<Artifact, Coordinate>(256);

            private CoordinateManager() {
            }

            Coordinate getCoordinate(DependencyNode node) {
                return this.coordinateMap.get(node);
            }

            Coordinate createCoordinate(DependencyNode node, int depth) {
                int seq = this.sequenceGen.computeIfAbsent(depth, k -> new AtomicInteger()).incrementAndGet();
                Coordinate coordinate = new Coordinate(depth, seq);
                this.coordinateMap.put(node, coordinate);
                return coordinate;
            }

            void updateLeftmost(DependencyNode current) {
                this.leftmostCoordinates.put(current.getArtifact(), this.getCoordinate(current));
            }

            boolean isLeftmost(DependencyNode node, List<DependencyNode> parents) {
                Coordinate leftmost = this.leftmostCoordinates.get(node.getArtifact());
                if (leftmost != null && leftmost.depth <= parents.size()) {
                    DependencyNode sameLevelNode = parents.get(leftmost.depth - 1);
                    return this.getCoordinate((DependencyNode)sameLevelNode).sequence < leftmost.sequence;
                }
                return false;
            }
        }

        private static final class Coordinate {
            int depth;
            int sequence;

            Coordinate(int depth, int sequence) {
                this.depth = depth;
                this.sequence = sequence;
            }

            public String toString() {
                return "{depth=" + this.depth + ", sequence=" + this.sequence + '}';
            }
        }
    }

    private static final class NeverDependencyResolutionSkipper
    extends DependencyResolutionSkipper {
        private static final DependencyResolutionSkipper INSTANCE = new NeverDependencyResolutionSkipper();

        private NeverDependencyResolutionSkipper() {
        }

        @Override
        public boolean skipResolution(DependencyNode node, List<DependencyNode> parents) {
            return false;
        }

        @Override
        public void cache(DependencyNode node, List<DependencyNode> parents) {
        }

        @Override
        public void report() {
        }
    }

    static final class DependencyResolutionResult {
        DependencyNode current;
        boolean skippedAsVersionConflict;
        boolean skippedAsDuplicate;
        boolean resolve;
        boolean forceResolution;

        DependencyResolutionResult(DependencyNode current) {
            this.current = current;
        }

        boolean toResolve() {
            return this.resolve || this.forceResolution;
        }
    }
}

