/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.wagon.shared.http;

import java.util.Objects;
import org.jetbrains.kotlin.org.apache.maven.wagon.proxy.ProxyInfo;
import org.jetbrains.kotlin.org.codehaus.plexus.util.StringUtils;

public class HttpMessageUtils {
    private static final int SC_UNAUTHORIZED = 401;
    private static final int SC_FORBIDDEN = 403;
    private static final int SC_NOT_FOUND = 404;
    private static final int SC_PROXY_AUTH_REQUIRED = 407;
    private static final int SC_GONE = 410;
    public static final int UNKNOWN_STATUS_CODE = -1;

    public static String formatTransferDebugMessage(String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        Objects.requireNonNull(url, "url cannot be null");
        String msg = url;
        if (statusCode != -1) {
            msg = msg + " -- status code: " + statusCode;
            if (StringUtils.isNotEmpty(reasonPhrase)) {
                msg = msg + ", reason phrase: " + reasonPhrase;
            }
        }
        if (proxyInfo != null) {
            msg = msg + " -- proxy: " + proxyInfo;
        }
        return msg;
    }

    public static String formatTransferFailedMessage(String url, ProxyInfo proxyInfo) {
        return HttpMessageUtils.formatTransferFailedMessage(url, -1, null, proxyInfo);
    }

    public static String formatTransferFailedMessage(String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        return HttpMessageUtils.formatMessage("transfer failed for ", url, statusCode, reasonPhrase, proxyInfo);
    }

    public static String formatAuthorizationMessage(String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        switch (statusCode) {
            case 401: {
                return HttpMessageUtils.formatMessage("authentication failed for ", url, statusCode, reasonPhrase, null);
            }
            case 403: {
                return HttpMessageUtils.formatMessage("authorization failed for ", url, statusCode, reasonPhrase, null);
            }
            case 407: {
                return HttpMessageUtils.formatMessage("proxy authentication failed for ", url, statusCode, reasonPhrase, null);
            }
        }
        return HttpMessageUtils.formatMessage("authorization failed for ", url, statusCode, reasonPhrase, proxyInfo);
    }

    public static String formatResourceDoesNotExistMessage(String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        return HttpMessageUtils.formatMessage("resource missing at ", url, statusCode, reasonPhrase, proxyInfo);
    }

    private static String formatMessage(String message, String url, int statusCode, String reasonPhrase, ProxyInfo proxyInfo) {
        Objects.requireNonNull(message, "message cannot be null");
        Objects.requireNonNull(url, "url cannot be null");
        String msg = message + url;
        if (statusCode != -1) {
            msg = msg + ", status: " + statusCode;
            if (StringUtils.isNotEmpty(reasonPhrase)) {
                msg = msg + " " + reasonPhrase;
            } else {
                switch (statusCode) {
                    case 401: {
                        msg = msg + " Unauthorized";
                        break;
                    }
                    case 403: {
                        msg = msg + " Forbidden";
                        break;
                    }
                    case 404: {
                        msg = msg + " Not Found";
                        break;
                    }
                    case 407: {
                        msg = msg + " Proxy Authentication Required";
                        break;
                    }
                    case 410: {
                        msg = msg + " Gone";
                        break;
                    }
                }
            }
        }
        if (proxyInfo != null) {
            msg = msg + ", proxy: " + proxyInfo;
        }
        return msg;
    }
}

