/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.toolchain.java;

import java.io.File;
import org.jetbrains.kotlin.org.apache.maven.toolchain.DefaultToolchain;
import org.jetbrains.kotlin.org.apache.maven.toolchain.java.JavaToolchain;
import org.jetbrains.kotlin.org.apache.maven.toolchain.model.ToolchainModel;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.Logger;
import org.jetbrains.kotlin.org.codehaus.plexus.util.FileUtils;
import org.jetbrains.kotlin.org.codehaus.plexus.util.Os;

public class JavaToolchainImpl
extends DefaultToolchain
implements JavaToolchain {
    private String javaHome;
    public static final String KEY_JAVAHOME = "jdkHome";

    JavaToolchainImpl(ToolchainModel model, Logger logger) {
        super(model, "jdk", logger);
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    @Override
    public String toString() {
        return "JDK[" + this.getJavaHome() + "]";
    }

    @Override
    public String findTool(String toolName) {
        File toRet = JavaToolchainImpl.findTool(toolName, new File(FileUtils.normalize(this.getJavaHome())));
        if (toRet != null) {
            return toRet.getAbsolutePath();
        }
        return null;
    }

    private static File findTool(String toolName, File installDir) {
        File bin = new File(installDir, "bin");
        if (bin.exists()) {
            File tool;
            boolean isWindows = Os.isFamily("windows");
            if (isWindows && (tool = new File(bin, toolName + ".exe")).exists()) {
                return tool;
            }
            tool = new File(bin, toolName);
            if (tool.exists()) {
                return tool;
            }
        }
        return null;
    }
}

