/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.toolchain.java;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.kotlin.org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.jetbrains.kotlin.org.apache.maven.toolchain.RequirementMatcher;
import org.jetbrains.kotlin.org.apache.maven.toolchain.RequirementMatcherFactory;
import org.jetbrains.kotlin.org.apache.maven.toolchain.ToolchainFactory;
import org.jetbrains.kotlin.org.apache.maven.toolchain.ToolchainPrivate;
import org.jetbrains.kotlin.org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.jetbrains.kotlin.org.apache.maven.toolchain.java.JavaToolchainImpl;
import org.jetbrains.kotlin.org.apache.maven.toolchain.model.ToolchainModel;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Component;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Requirement;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.Logger;
import org.jetbrains.kotlin.org.codehaus.plexus.util.FileUtils;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=ToolchainFactory.class, hint="jdk")
public class JavaToolchainFactory
implements ToolchainFactory {
    @Requirement
    private Logger logger;

    @Override
    public ToolchainPrivate createToolchain(ToolchainModel model) throws MisconfiguredToolchainException {
        if (model == null) {
            return null;
        }
        DefaultJavaToolChain jtc = new DefaultJavaToolChain(model, this.logger);
        Properties provides = model.getProvides();
        for (Map.Entry<Object, Object> provide : provides.entrySet()) {
            String key = (String)provide.getKey();
            String value = (String)provide.getValue();
            if (value == null) {
                throw new MisconfiguredToolchainException("Provides token '" + key + "' doesn't have any value configured.");
            }
            RequirementMatcher matcher = "version".equals(key) ? RequirementMatcherFactory.createVersionMatcher(value) : RequirementMatcherFactory.createExactMatcher(value);
            jtc.addProvideToken(key, matcher);
        }
        Xpp3Dom dom = (Xpp3Dom)model.getConfiguration();
        Xpp3Dom javahome = dom.getChild("jdkHome");
        if (javahome == null) {
            throw new MisconfiguredToolchainException("Java toolchain without the jdkHome configuration element.");
        }
        File normal = new File(FileUtils.normalize(javahome.getValue()));
        if (!normal.exists()) {
            throw new MisconfiguredToolchainException("Non-existing JDK home configuration at " + normal.getAbsolutePath());
        }
        ((JavaToolchainImpl)jtc).setJavaHome(FileUtils.normalize(javahome.getValue()));
        return jtc;
    }

    @Override
    public ToolchainPrivate createDefaultToolchain() {
        return null;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

