/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.toolchain;

import org.jetbrains.kotlin.org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.kotlin.org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.jetbrains.kotlin.org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.kotlin.org.apache.maven.toolchain.RequirementMatcher;

public final class RequirementMatcherFactory {
    private RequirementMatcherFactory() {
    }

    public static RequirementMatcher createExactMatcher(String provideValue) {
        return new ExactMatcher(provideValue);
    }

    public static RequirementMatcher createVersionMatcher(String provideValue) {
        return new VersionMatcher(provideValue);
    }

    private static final class VersionMatcher
    implements RequirementMatcher {
        DefaultArtifactVersion version;

        private VersionMatcher(String version) {
            this.version = new DefaultArtifactVersion(version);
        }

        @Override
        public boolean matches(String requirement) {
            try {
                VersionRange range = VersionRange.createFromVersionSpec(requirement);
                if (range.hasRestrictions()) {
                    return range.containsVersion(this.version);
                }
                return range.getRecommendedVersion().compareTo(this.version) == 0;
            }
            catch (InvalidVersionSpecificationException ex) {
                ex.printStackTrace();
                return false;
            }
        }

        public String toString() {
            return this.version.toString();
        }
    }

    private static final class ExactMatcher
    implements RequirementMatcher {
        private String provides;

        private ExactMatcher(String provides) {
            this.provides = provides;
        }

        @Override
        public boolean matches(String requirement) {
            return this.provides.equalsIgnoreCase(requirement);
        }

        public String toString() {
            return this.provides;
        }
    }
}

