/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.rtinfo.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jetbrains.kotlin.org.apache.commons.lang3.StringUtils;
import org.jetbrains.kotlin.org.apache.commons.lang3.Validate;
import org.jetbrains.kotlin.org.apache.maven.rtinfo.RuntimeInformation;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Component;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Requirement;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.Logger;
import org.jetbrains.kotlin.org.eclipse.aether.util.version.GenericVersionScheme;
import org.jetbrains.kotlin.org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.jetbrains.kotlin.org.eclipse.aether.version.Version;
import org.jetbrains.kotlin.org.eclipse.aether.version.VersionConstraint;

@Component(role=RuntimeInformation.class)
public class DefaultRuntimeInformation
implements RuntimeInformation {
    @Requirement
    private Logger logger;
    private String mavenVersion;

    @Override
    public String getMavenVersion() {
        if (this.mavenVersion == null) {
            Properties props = new Properties();
            String resource = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
            try (InputStream is = DefaultRuntimeInformation.class.getResourceAsStream("/" + resource);){
                if (is != null) {
                    props.load(is);
                } else {
                    this.logger.warn("Could not locate " + resource + " on classpath, Maven runtime information not available");
                }
            }
            catch (IOException e) {
                String msg = "Could not parse " + resource + ", Maven runtime information not available";
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn(msg, e);
                }
                this.logger.warn(msg);
            }
            String version = props.getProperty("version", "").trim();
            this.mavenVersion = !version.startsWith("${") ? version : "";
        }
        return this.mavenVersion;
    }

    @Override
    public boolean isMavenVersion(String versionRange) {
        Version current;
        VersionConstraint constraint;
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        Validate.notBlank(versionRange, "versionRange can neither be null, empty nor blank", new Object[0]);
        try {
            constraint = versionScheme.parseVersionConstraint(versionRange);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        try {
            String mavenVersion = this.getMavenVersion();
            Validate.validState(StringUtils.isNotEmpty(mavenVersion), "Could not determine current Maven version", new Object[0]);
            current = versionScheme.parseVersion(mavenVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalStateException("Could not parse current Maven version: " + e.getMessage(), e);
        }
        if (constraint.getRange() == null) {
            return constraint.getVersion().compareTo(current) <= 0;
        }
        return constraint.containsVersion(current);
    }
}

