/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.project.artifact;

import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.org.apache.maven.artifact.DefaultArtifact;
import org.jetbrains.kotlin.org.apache.maven.artifact.handler.ArtifactHandler;
import org.jetbrains.kotlin.org.apache.maven.model.Dependency;
import org.jetbrains.kotlin.org.apache.maven.model.DependencyManagement;
import org.jetbrains.kotlin.org.apache.maven.project.MavenProject;
import org.jetbrains.kotlin.org.apache.maven.project.artifact.ArtifactWithDependencies;

public class ProjectArtifact
extends DefaultArtifact
implements ArtifactWithDependencies {
    private MavenProject project;

    public ProjectArtifact(MavenProject project) {
        super(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, "pom", null, (ArtifactHandler)new PomArtifactHandler());
        this.project = project;
        this.setFile(project.getFile());
        this.setResolved(true);
    }

    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public List<Dependency> getDependencies() {
        return this.project.getDependencies();
    }

    @Override
    public List<Dependency> getManagedDependencies() {
        DependencyManagement depMngt = this.project.getDependencyManagement();
        return depMngt != null ? Collections.unmodifiableList(depMngt.getDependencies()) : Collections.emptyList();
    }

    static class PomArtifactHandler
    implements ArtifactHandler {
        PomArtifactHandler() {
        }

        @Override
        public String getClassifier() {
            return null;
        }

        @Override
        public String getDirectory() {
            return null;
        }

        @Override
        public String getExtension() {
            return "pom";
        }

        @Override
        public String getLanguage() {
            return "none";
        }

        @Override
        public String getPackaging() {
            return "pom";
        }

        @Override
        public boolean isAddedToClasspath() {
            return false;
        }

        @Override
        public boolean isIncludesDependencies() {
            return false;
        }
    }
}

