/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.plugin.prefix;

import java.util.List;
import org.jetbrains.kotlin.org.eclipse.aether.repository.LocalRepository;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;

public class NoPluginFoundForPrefixException
extends Exception {
    public NoPluginFoundForPrefixException(String prefix, List<String> pluginGroups, LocalRepository localRepository, List<RemoteRepository> remoteRepositories) {
        super("No plugin found for prefix '" + prefix + "' in the current project and in the plugin groups " + pluginGroups + " available from the repositories " + NoPluginFoundForPrefixException.format(localRepository, remoteRepositories));
    }

    private static String format(LocalRepository localRepository, List<RemoteRepository> remoteRepositories) {
        String repos = "[";
        if (localRepository != null) {
            repos = repos + localRepository.getId() + " (" + localRepository.getBasedir() + ")";
        }
        if (remoteRepositories != null && !remoteRepositories.isEmpty()) {
            for (RemoteRepository repository : remoteRepositories) {
                repos = repos + ", ";
                if (repository == null) continue;
                repos = repos + repository.getId() + " (" + repository.getUrl() + ")";
            }
        }
        repos = repos + "]";
        return repos;
    }
}

