/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.plugin.internal;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.maven.artifact.Artifact;
import org.jetbrains.kotlin.org.apache.maven.artifact.resolver.ResolutionListener;
import org.jetbrains.kotlin.org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.jetbrains.kotlin.org.apache.maven.artifact.versioning.VersionRange;

class PluginDependencyResolutionListener
implements ResolutionListener {
    private ArtifactFilter coreFilter;
    private LinkedList<Artifact> coreArtifacts = new LinkedList();
    private Artifact wagonProvider;
    private Map<Artifact, Object> bannedArtifacts = new IdentityHashMap<Artifact, Object>();

    PluginDependencyResolutionListener(ArtifactFilter coreFilter) {
        this.coreFilter = coreFilter;
    }

    public void removeBannedDependencies(Collection<Artifact> artifacts) {
        if (!this.bannedArtifacts.isEmpty() && artifacts != null) {
            Iterator<Artifact> it = artifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact = it.next();
                if (!this.bannedArtifacts.containsKey(artifact)) continue;
                it.remove();
            }
        }
    }

    @Override
    public void startProcessChildren(Artifact artifact) {
        if (this.wagonProvider == null) {
            if (this.isLegacyCoreArtifact(artifact)) {
                this.coreArtifacts.addFirst(artifact);
            } else if (!this.coreArtifacts.isEmpty() && this.isWagonProvider(artifact)) {
                this.wagonProvider = artifact;
                this.bannedArtifacts.put(artifact, null);
            }
        }
    }

    private boolean isLegacyCoreArtifact(Artifact artifact) {
        String version = artifact.getVersion();
        return version != null && version.startsWith("2.") && !this.coreFilter.include(artifact);
    }

    @Override
    public void endProcessChildren(Artifact artifact) {
        if (this.wagonProvider == artifact) {
            this.wagonProvider = null;
        } else if (this.coreArtifacts.peek() == artifact) {
            this.coreArtifacts.removeFirst();
        }
    }

    @Override
    public void includeArtifact(Artifact artifact) {
        if (this.wagonProvider != null) {
            this.bannedArtifacts.put(artifact, null);
        }
    }

    private boolean isWagonProvider(Artifact artifact) {
        if ("org.jetbrains.kotlin.org.apache.maven.wagon".equals(artifact.getGroupId())) {
            return artifact.getArtifactId().startsWith("wagon-");
        }
        return false;
    }

    @Override
    public void manageArtifact(Artifact artifact, Artifact replacement) {
    }

    @Override
    public void omitForCycle(Artifact artifact) {
    }

    @Override
    public void omitForNearer(Artifact omitted, Artifact kept) {
    }

    @Override
    public void restrictRange(Artifact artifact, Artifact replacement, VersionRange newRange) {
    }

    @Override
    public void selectVersionFromRange(Artifact artifact) {
    }

    @Override
    public void testArtifact(Artifact node) {
    }

    @Override
    public void updateScope(Artifact artifact, String scope) {
    }

    @Override
    public void updateScopeCurrentPom(Artifact artifact, String ignoredScope) {
    }
}

