/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.plugin.internal;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.kotlin.org.apache.maven.RepositoryUtils;
import org.jetbrains.kotlin.org.apache.maven.model.Plugin;
import org.jetbrains.kotlin.org.apache.maven.plugin.PluginResolutionException;
import org.jetbrains.kotlin.org.apache.maven.plugin.internal.PlexusUtilsInjector;
import org.jetbrains.kotlin.org.apache.maven.plugin.internal.PluginDependenciesResolver;
import org.jetbrains.kotlin.org.apache.maven.plugin.internal.WagonExcluder;
import org.jetbrains.kotlin.org.apache.maven.repository.internal.RelocatedArtifact;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Component;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Requirement;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.Logger;
import org.jetbrains.kotlin.org.codehaus.plexus.util.StringUtils;
import org.jetbrains.kotlin.org.eclipse.aether.DefaultRepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystem;
import org.jetbrains.kotlin.org.eclipse.aether.RepositorySystemSession;
import org.jetbrains.kotlin.org.eclipse.aether.RequestTrace;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.Artifact;
import org.jetbrains.kotlin.org.eclipse.aether.artifact.DefaultArtifact;
import org.jetbrains.kotlin.org.eclipse.aether.collection.CollectRequest;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyCollectionException;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencyGraphTransformer;
import org.jetbrains.kotlin.org.eclipse.aether.collection.DependencySelector;
import org.jetbrains.kotlin.org.eclipse.aether.graph.Dependency;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyFilter;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyNode;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyVisitor;
import org.jetbrains.kotlin.org.eclipse.aether.graph.Exclusion;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.ArtifactResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.DependencyRequest;
import org.jetbrains.kotlin.org.eclipse.aether.resolution.DependencyResolutionException;
import org.jetbrains.kotlin.org.eclipse.aether.util.filter.AndDependencyFilter;
import org.jetbrains.kotlin.org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.manager.DependencyManagerUtils;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.jetbrains.kotlin.org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.jetbrains.kotlin.org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;

@Component(role=PluginDependenciesResolver.class)
public class DefaultPluginDependenciesResolver
implements PluginDependenciesResolver {
    private static final String REPOSITORY_CONTEXT = "plugin";
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repoSystem;

    private Artifact toArtifact(Plugin plugin, RepositorySystemSession session) {
        return new DefaultArtifact(plugin.getGroupId(), plugin.getArtifactId(), null, "jar", plugin.getVersion(), session.getArtifactTypeRegistry().get("maven-plugin"));
    }

    @Override
    public Artifact resolve(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        RequestTrace trace = RequestTrace.newChild(null, plugin);
        Artifact pluginArtifact = this.toArtifact(plugin, session);
        try {
            String requiredMavenVersion;
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session);
            pluginSession.setArtifactDescriptorPolicy(new SimpleArtifactDescriptorPolicy(true, false));
            ArtifactDescriptorRequest request = new ArtifactDescriptorRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace);
            ArtifactDescriptorResult result = this.repoSystem.readArtifactDescriptor(pluginSession, request);
            pluginArtifact = result.getArtifact();
            if (this.logger.isWarnEnabled() && !result.getRelocations().isEmpty()) {
                String message = pluginArtifact instanceof RelocatedArtifact ? ((RelocatedArtifact)pluginArtifact).getMessage() : null;
                this.logger.warn("The artifact " + result.getRelocations().get(0) + " has been relocated to " + pluginArtifact + (message != null ? ": " + message : ""));
            }
            if ((requiredMavenVersion = (String)result.getProperties().get("prerequisites.maven")) != null) {
                LinkedHashMap<String, String> props = new LinkedHashMap<String, String>(pluginArtifact.getProperties());
                props.put("requiredMavenVersion", requiredMavenVersion);
                pluginArtifact = pluginArtifact.setProperties(props);
            }
        }
        catch (ArtifactDescriptorException e) {
            throw new PluginResolutionException(plugin, (Throwable)e);
        }
        try {
            ArtifactRequest request = new ArtifactRequest(pluginArtifact, repositories, REPOSITORY_CONTEXT);
            request.setTrace(trace);
            pluginArtifact = this.repoSystem.resolveArtifact(session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new PluginResolutionException(plugin, (Throwable)e);
        }
        return pluginArtifact;
    }

    public DependencyNode resolveCoreExtension(Plugin plugin, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return this.resolveInternal(plugin, null, dependencyFilter, null, repositories, session);
    }

    @Override
    public DependencyNode resolve(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        return this.resolveInternal(plugin, pluginArtifact, dependencyFilter, new PlexusUtilsInjector(), repositories, session);
    }

    private DependencyNode resolveInternal(Plugin plugin, Artifact pluginArtifact, DependencyFilter dependencyFilter, DependencyGraphTransformer transformer, List<RemoteRepository> repositories, RepositorySystemSession session) throws PluginResolutionException {
        DependencyNode node;
        RequestTrace trace = RequestTrace.newChild(null, plugin);
        if (pluginArtifact == null) {
            pluginArtifact = this.toArtifact(plugin, session);
        }
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter("provided", "test");
        DependencyFilter resolutionFilter = AndDependencyFilter.newInstance(collectionFilter, dependencyFilter);
        try {
            DependencySelector selector = AndDependencySelector.newInstance(session.getDependencySelector(), new WagonExcluder());
            transformer = ChainedDependencyGraphTransformer.newInstance(session.getDependencyGraphTransformer(), transformer);
            DefaultRepositorySystemSession pluginSession = new DefaultRepositorySystemSession(session);
            pluginSession.setDependencySelector(selector);
            pluginSession.setDependencyGraphTransformer(transformer);
            CollectRequest request = new CollectRequest();
            request.setRequestContext(REPOSITORY_CONTEXT);
            request.setRepositories(repositories);
            request.setRoot(new Dependency(pluginArtifact, null));
            for (org.jetbrains.kotlin.org.apache.maven.model.Dependency dependency : plugin.getDependencies()) {
                Dependency pluginDep = RepositoryUtils.toDependency(dependency, session.getArtifactTypeRegistry());
                if (!"system".equals(pluginDep.getScope())) {
                    pluginDep = pluginDep.setScope("runtime");
                }
                request.addDependency(pluginDep);
            }
            DependencyRequest depRequest = new DependencyRequest(request, resolutionFilter);
            depRequest.setTrace(trace);
            request.setTrace(RequestTrace.newChild(trace, depRequest));
            node = this.repoSystem.collectDependencies(pluginSession, request).getRoot();
            if (this.logger.isDebugEnabled()) {
                node.accept(new GraphLogger());
            }
            depRequest.setRoot(node);
            this.repoSystem.resolveDependencies(session, depRequest);
        }
        catch (DependencyCollectionException e) {
            throw new PluginResolutionException(plugin, (Throwable)e);
        }
        catch (DependencyResolutionException e) {
            throw new PluginResolutionException(plugin, e.getCause());
        }
        return node;
    }

    class GraphLogger
    implements DependencyVisitor {
        private String indent = "";

        GraphLogger() {
        }

        @Override
        public boolean visitEnter(DependencyNode node) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.indent);
            Dependency dep = node.getDependency();
            if (dep != null) {
                Artifact art = dep.getArtifact();
                buffer.append(art);
                if (StringUtils.isNotEmpty(dep.getScope())) {
                    buffer.append(':').append(dep.getScope());
                }
                if (dep.isOptional()) {
                    buffer.append(" (optional)");
                }
                if ((node.getManagedBits() & 2) == 2) {
                    String premanagedScope = DependencyManagerUtils.getPremanagedScope(node);
                    buffer.append(" (scope managed from ");
                    buffer.append(Objects.toString(premanagedScope, "default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 1) == 1) {
                    String premanagedVersion = DependencyManagerUtils.getPremanagedVersion(node);
                    buffer.append(" (version managed from ");
                    buffer.append(Objects.toString(premanagedVersion, "default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 4) == 4) {
                    Boolean premanagedOptional = DependencyManagerUtils.getPremanagedOptional(node);
                    buffer.append(" (optionality managed from ");
                    buffer.append(Objects.toString(premanagedOptional, "default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 0x10) == 16) {
                    Collection<Exclusion> premanagedExclusions = DependencyManagerUtils.getPremanagedExclusions(node);
                    buffer.append(" (exclusions managed from ");
                    buffer.append(Objects.toString(premanagedExclusions, "default"));
                    buffer.append(')');
                }
                if ((node.getManagedBits() & 8) == 8) {
                    Map<String, String> premanagedProperties = DependencyManagerUtils.getPremanagedProperties(node);
                    buffer.append(" (properties managed from ");
                    buffer.append(Objects.toString(premanagedProperties, "default"));
                    buffer.append(')');
                }
            }
            DefaultPluginDependenciesResolver.this.logger.debug(buffer.toString());
            this.indent = this.indent + "   ";
            return true;
        }

        @Override
        public boolean visitLeave(DependencyNode node) {
            this.indent = this.indent.substring(0, this.indent.length() - 3);
            return true;
        }
    }
}

