/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.plugin.descriptor;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.jetbrains.kotlin.org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.jetbrains.kotlin.org.apache.maven.plugin.descriptor.Parameter;
import org.jetbrains.kotlin.org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.jetbrains.kotlin.org.codehaus.plexus.component.repository.ComponentDependency;
import org.jetbrains.kotlin.org.codehaus.plexus.component.repository.ComponentRequirement;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PluginDescriptorBuilder {
    public PluginDescriptor build(Reader reader) throws PlexusConfigurationException {
        return this.build(reader, null);
    }

    public PluginDescriptor build(Reader reader, String source) throws PlexusConfigurationException {
        PlexusConfiguration[] mojoConfigurations;
        String inheritedByDefault;
        PlexusConfiguration c = this.buildConfiguration(reader);
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setSource(source);
        pluginDescriptor.setGroupId(c.getChild("groupId").getValue());
        pluginDescriptor.setArtifactId(c.getChild("artifactId").getValue());
        pluginDescriptor.setVersion(c.getChild("version").getValue());
        pluginDescriptor.setGoalPrefix(c.getChild("goalPrefix").getValue());
        pluginDescriptor.setName(c.getChild("name").getValue());
        pluginDescriptor.setDescription(c.getChild("description").getValue());
        String isolatedRealm = c.getChild("isolatedRealm").getValue();
        if (isolatedRealm != null) {
            pluginDescriptor.setIsolatedRealm(Boolean.parseBoolean(isolatedRealm));
        }
        if ((inheritedByDefault = c.getChild("inheritedByDefault").getValue()) != null) {
            pluginDescriptor.setInheritedByDefault(Boolean.parseBoolean(inheritedByDefault));
        }
        for (PlexusConfiguration component : mojoConfigurations = c.getChild("mojos").getChildren("mojo")) {
            MojoDescriptor mojoDescriptor = this.buildComponentDescriptor(component, pluginDescriptor);
            pluginDescriptor.addMojo(mojoDescriptor);
        }
        PlexusConfiguration[] dependencyConfigurations = c.getChild("dependencies").getChildren("dependency");
        ArrayList<ComponentDependency> dependencies = new ArrayList<ComponentDependency>();
        for (PlexusConfiguration d : dependencyConfigurations) {
            ComponentDependency cd2 = new ComponentDependency();
            cd2.setArtifactId(d.getChild("artifactId").getValue());
            cd2.setGroupId(d.getChild("groupId").getValue());
            cd2.setType(d.getChild("type").getValue());
            cd2.setVersion(d.getChild("version").getValue());
            dependencies.add(cd2);
        }
        pluginDescriptor.setDependencies(dependencies);
        return pluginDescriptor;
    }

    public MojoDescriptor buildComponentDescriptor(PlexusConfiguration c, PluginDescriptor pluginDescriptor) throws PlexusConfigurationException {
        PlexusConfiguration[] requirements;
        String threadSafe;
        String inheritedByDefault;
        String requiresOnline;
        String aggregator;
        String requiresReports;
        String requiresProject;
        String directInvocationOnly;
        PlexusConfiguration dependencyCollection;
        String executeLifecycle;
        String executeMojo;
        String executePhase;
        String phase;
        PlexusConfiguration deprecated;
        String since;
        PlexusConfiguration composerConfig;
        PlexusConfiguration configuratorConfig;
        MojoDescriptor mojo = new MojoDescriptor();
        mojo.setPluginDescriptor(pluginDescriptor);
        mojo.setGoal(c.getChild("goal").getValue());
        mojo.setImplementation(c.getChild("implementation").getValue());
        PlexusConfiguration langConfig = c.getChild("language");
        if (langConfig != null) {
            mojo.setLanguage(langConfig.getValue());
        }
        if ((configuratorConfig = c.getChild("configurator")) != null) {
            mojo.setComponentConfigurator(configuratorConfig.getValue());
        }
        if ((composerConfig = c.getChild("composer")) != null) {
            mojo.setComponentComposer(composerConfig.getValue());
        }
        if ((since = c.getChild("since").getValue()) != null) {
            mojo.setSince(since);
        }
        if ((deprecated = c.getChild("deprecated", false)) != null) {
            mojo.setDeprecated(deprecated.getValue());
        }
        if ((phase = c.getChild("phase").getValue()) != null) {
            mojo.setPhase(phase);
        }
        if ((executePhase = c.getChild("executePhase").getValue()) != null) {
            mojo.setExecutePhase(executePhase);
        }
        if ((executeMojo = c.getChild("executeGoal").getValue()) != null) {
            mojo.setExecuteGoal(executeMojo);
        }
        if ((executeLifecycle = c.getChild("executeLifecycle").getValue()) != null) {
            mojo.setExecuteLifecycle(executeLifecycle);
        }
        mojo.setInstantiationStrategy(c.getChild("instantiationStrategy").getValue());
        mojo.setDescription(c.getChild("description").getValue());
        PlexusConfiguration dependencyResolution = c.getChild("requiresDependencyResolution", false);
        if (dependencyResolution != null) {
            mojo.setDependencyResolutionRequired(dependencyResolution.getValue());
        }
        if ((dependencyCollection = c.getChild("requiresDependencyCollection", false)) != null) {
            mojo.setDependencyCollectionRequired(dependencyCollection.getValue());
        }
        if ((directInvocationOnly = c.getChild("requiresDirectInvocation").getValue()) != null) {
            mojo.setDirectInvocationOnly(Boolean.parseBoolean(directInvocationOnly));
        }
        if ((requiresProject = c.getChild("requiresProject").getValue()) != null) {
            mojo.setProjectRequired(Boolean.parseBoolean(requiresProject));
        }
        if ((requiresReports = c.getChild("requiresReports").getValue()) != null) {
            mojo.setRequiresReports(Boolean.parseBoolean(requiresReports));
        }
        if ((aggregator = c.getChild("aggregator").getValue()) != null) {
            mojo.setAggregator(Boolean.parseBoolean(aggregator));
        }
        if ((requiresOnline = c.getChild("requiresOnline").getValue()) != null) {
            mojo.setOnlineRequired(Boolean.parseBoolean(requiresOnline));
        }
        if ((inheritedByDefault = c.getChild("inheritedByDefault").getValue()) != null) {
            mojo.setInheritedByDefault(Boolean.parseBoolean(inheritedByDefault));
        }
        if ((threadSafe = c.getChild("threadSafe").getValue()) != null) {
            mojo.setThreadSafe(Boolean.parseBoolean(threadSafe));
        }
        PlexusConfiguration mojoConfig = c.getChild("configuration");
        mojo.setMojoConfiguration(mojoConfig);
        PlexusConfiguration[] parameterConfigurations = c.getChild("parameters").getChildren("parameter");
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (PlexusConfiguration d : parameterConfigurations) {
            Parameter parameter = new Parameter();
            parameter.setName(d.getChild("name").getValue());
            parameter.setAlias(d.getChild("alias").getValue());
            parameter.setType(d.getChild("type").getValue());
            String required = d.getChild("required").getValue();
            parameter.setRequired(Boolean.parseBoolean(required));
            PlexusConfiguration editableConfig = d.getChild("editable");
            if (editableConfig != null) {
                String editable = d.getChild("editable").getValue();
                parameter.setEditable(editable == null || Boolean.parseBoolean(editable));
            }
            parameter.setDescription(d.getChild("description").getValue());
            parameter.setDeprecated(d.getChild("deprecated").getValue());
            parameter.setImplementation(d.getChild("implementation").getValue());
            parameter.setSince(d.getChild("since").getValue());
            PlexusConfiguration paramConfig = mojoConfig.getChild(parameter.getName(), false);
            if (paramConfig != null) {
                parameter.setExpression(paramConfig.getValue(null));
                parameter.setDefaultValue(paramConfig.getAttribute("default-value"));
            }
            parameters.add(parameter);
        }
        mojo.setParameters(parameters);
        for (PlexusConfiguration requirement : requirements = c.getChild("requirements").getChildren("requirement")) {
            ComponentRequirement cr = new ComponentRequirement();
            cr.setRole(requirement.getChild("role").getValue());
            cr.setRoleHint(requirement.getChild("role-hint").getValue());
            cr.setFieldName(requirement.getChild("field-name").getValue());
            mojo.addRequirement(cr);
        }
        return mojo;
    }

    public PlexusConfiguration buildConfiguration(Reader configuration) throws PlexusConfigurationException {
        try {
            return new XmlPlexusConfiguration(Xpp3DomBuilder.build(configuration));
        }
        catch (IOException | XmlPullParserException e) {
            throw new PlexusConfigurationException(e.getMessage(), e);
        }
    }
}

