/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.LifeCyclePluginAnalyzer;
import org.jetbrains.kotlin.org.apache.maven.model.Build;
import org.jetbrains.kotlin.org.apache.maven.model.Model;
import org.jetbrains.kotlin.org.apache.maven.model.Plugin;
import org.jetbrains.kotlin.org.apache.maven.model.PluginContainer;
import org.jetbrains.kotlin.org.apache.maven.model.PluginExecution;
import org.jetbrains.kotlin.org.apache.maven.model.PluginManagement;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelBuildingRequest;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblem;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblemCollector;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.jetbrains.kotlin.org.apache.maven.model.merge.MavenModelMerger;
import org.jetbrains.kotlin.org.apache.maven.model.plugin.LifecycleBindingsInjector;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Component;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Requirement;

@Component(role=LifecycleBindingsInjector.class)
public class DefaultLifecycleBindingsInjector
implements LifecycleBindingsInjector {
    private LifecycleBindingsMerger merger = new LifecycleBindingsMerger();
    @Requirement
    private LifeCyclePluginAnalyzer lifecycle;

    @Override
    public void injectLifecycleBindings(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        String packaging = model.getPackaging();
        Set<Plugin> defaultPlugins = this.lifecycle.getPluginsBoundByDefaultToAllLifecycles(packaging);
        if (defaultPlugins == null) {
            problems.add(new ModelProblemCollectorRequest(ModelProblem.Severity.ERROR, ModelProblem.Version.BASE).setMessage("Unknown packaging: " + packaging).setLocation(model.getLocation("packaging")));
        } else if (!defaultPlugins.isEmpty()) {
            Model lifecycleModel = new Model();
            lifecycleModel.setBuild(new Build());
            lifecycleModel.getBuild().getPlugins().addAll(defaultPlugins);
            this.merger.merge(model, lifecycleModel);
        }
    }

    protected static class LifecycleBindingsMerger
    extends MavenModelMerger {
        private static final String PLUGIN_MANAGEMENT = "plugin-management";

        protected LifecycleBindingsMerger() {
        }

        public void merge(Model target, Model source) {
            if (target.getBuild() == null) {
                target.setBuild(new Build());
            }
            Map<Object, Object> context = Collections.singletonMap(PLUGIN_MANAGEMENT, target.getBuild().getPluginManagement());
            this.mergePluginContainer_Plugins(target.getBuild(), source.getBuild(), false, context);
        }

        @Override
        protected void mergePluginContainer_Plugins(PluginContainer target, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List<Plugin> src = source.getPlugins();
            if (!src.isEmpty()) {
                PluginManagement pluginManagement;
                List<Plugin> tgt = target.getPlugins();
                LinkedHashMap<Object, Plugin> merged = new LinkedHashMap<Object, Plugin>((src.size() + tgt.size()) * 2);
                for (Plugin plugin : tgt) {
                    Object key = this.getPluginKey(plugin);
                    merged.put(key, plugin);
                }
                LinkedHashMap<Object, Plugin> added = new LinkedHashMap<Object, Plugin>();
                for (Plugin element : src) {
                    Object key = this.getPluginKey(element);
                    Plugin existing = (Plugin)merged.get(key);
                    if (existing != null) {
                        this.mergePlugin(existing, element, sourceDominant, context);
                        continue;
                    }
                    merged.put(key, element);
                    added.put(key, element);
                }
                if (!added.isEmpty() && (pluginManagement = (PluginManagement)context.get(PLUGIN_MANAGEMENT)) != null) {
                    for (Plugin managedPlugin : pluginManagement.getPlugins()) {
                        Object key = this.getPluginKey(managedPlugin);
                        Plugin addedPlugin = (Plugin)added.get(key);
                        if (addedPlugin == null) continue;
                        Plugin plugin = managedPlugin.clone();
                        this.mergePlugin(plugin, addedPlugin, sourceDominant, Collections.emptyMap());
                        merged.put(key, plugin);
                    }
                }
                ArrayList<Plugin> arrayList = new ArrayList<Plugin>(merged.values());
                target.setPlugins(arrayList);
            }
        }

        @Override
        protected void mergePluginExecution(PluginExecution target, PluginExecution source, boolean sourceDominant, Map<Object, Object> context) {
            super.mergePluginExecution(target, source, sourceDominant, context);
            target.setPriority(Math.min(target.getPriority(), source.getPriority()));
        }
    }
}

