/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model.interpolation;

import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.apache.maven.model.building.ModelBuildingRequest;
import org.jetbrains.kotlin.org.apache.maven.model.interpolation.ModelVersionProcessor;

@Named
@Singleton
public class DefaultModelVersionProcessor
implements ModelVersionProcessor {
    private static final String SHA1_PROPERTY = "sha1";
    private static final String CHANGELIST_PROPERTY = "changelist";
    private static final String REVISION_PROPERTY = "revision";

    @Override
    public boolean isValidProperty(String property) {
        return REVISION_PROPERTY.equals(property) || CHANGELIST_PROPERTY.equals(property) || SHA1_PROPERTY.equals(property);
    }

    @Override
    public void overwriteModelProperties(Properties modelProperties, ModelBuildingRequest request) {
        if (request.getSystemProperties().containsKey(REVISION_PROPERTY)) {
            modelProperties.put(REVISION_PROPERTY, request.getSystemProperties().get(REVISION_PROPERTY));
        }
        if (request.getSystemProperties().containsKey(CHANGELIST_PROPERTY)) {
            modelProperties.put(CHANGELIST_PROPERTY, request.getSystemProperties().get(CHANGELIST_PROPERTY));
        }
        if (request.getSystemProperties().containsKey(SHA1_PROPERTY)) {
            modelProperties.put(SHA1_PROPERTY, request.getSystemProperties().get(SHA1_PROPERTY));
        }
    }
}

