/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.lifecycle.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.MavenExecutionPlan;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.ExecutionPlanItem;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.ProjectSegment;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import org.jetbrains.kotlin.org.apache.maven.plugin.MojoExecution;
import org.jetbrains.kotlin.org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.jetbrains.kotlin.org.apache.maven.project.MavenProject;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Component;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Requirement;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.Logger;
import org.jetbrains.kotlin.org.codehaus.plexus.util.StringUtils;

@Component(role=LifecycleDebugLogger.class)
public class LifecycleDebugLogger {
    @Requirement
    private Logger logger;

    public LifecycleDebugLogger() {
    }

    public LifecycleDebugLogger(Logger logger) {
        this.logger = logger;
    }

    public void debug(String s2) {
        this.logger.debug(s2);
    }

    public void info(String s2) {
        this.logger.info(s2);
    }

    public void debugReactorPlan(ProjectBuildList projectBuilds) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.debug("=== REACTOR BUILD PLAN ================================================");
        Iterator<ProjectSegment> it = projectBuilds.iterator();
        while (it.hasNext()) {
            ProjectSegment projectBuild = it.next();
            this.logger.debug("Project: " + projectBuild.getProject().getId());
            this.logger.debug("Tasks:   " + projectBuild.getTaskSegment().getTasks());
            this.logger.debug("Style:   " + (projectBuild.getTaskSegment().isAggregating() ? "Aggregating" : "Regular"));
            if (!it.hasNext()) continue;
            this.logger.debug("-----------------------------------------------------------------------");
        }
        this.logger.debug("=======================================================================");
    }

    public void debugProjectPlan(MavenProject currentProject, MavenExecutionPlan executionPlan) {
        if (!this.logger.isDebugEnabled()) {
            return;
        }
        this.logger.debug("=== PROJECT BUILD PLAN ================================================");
        this.logger.debug("Project:       " + BuilderCommon.getKey(currentProject));
        this.debugDependencyRequirements(executionPlan.getMojoExecutions());
        this.logger.debug("Repositories (dependencies): " + currentProject.getRemoteProjectRepositories());
        this.logger.debug("Repositories (plugins)     : " + currentProject.getRemotePluginRepositories());
        for (ExecutionPlanItem mojoExecution : executionPlan) {
            this.debugMojoExecution(mojoExecution.getMojoExecution());
        }
        this.logger.debug("=======================================================================");
    }

    private void debugMojoExecution(MojoExecution mojoExecution) {
        String mojoExecId = mojoExecution.getGroupId() + ':' + mojoExecution.getArtifactId() + ':' + mojoExecution.getVersion() + ':' + mojoExecution.getGoal() + " (" + mojoExecution.getExecutionId() + ')';
        Map<String, List<MojoExecution>> forkedExecutions = mojoExecution.getForkedExecutions();
        if (!forkedExecutions.isEmpty()) {
            for (Map.Entry<String, List<MojoExecution>> fork : forkedExecutions.entrySet()) {
                this.logger.debug("--- init fork of " + fork.getKey() + " for " + mojoExecId + " ---");
                this.debugDependencyRequirements(fork.getValue());
                for (MojoExecution forkedExecution : fork.getValue()) {
                    this.debugMojoExecution(forkedExecution);
                }
                this.logger.debug("--- exit fork of " + fork.getKey() + " for " + mojoExecId + " ---");
            }
        }
        this.logger.debug("-----------------------------------------------------------------------");
        this.logger.debug("Goal:          " + mojoExecId);
        this.logger.debug("Style:         " + (mojoExecution.getMojoDescriptor().isAggregator() ? "Aggregating" : "Regular"));
        this.logger.debug("Configuration: " + mojoExecution.getConfiguration());
    }

    private void debugDependencyRequirements(List<MojoExecution> mojoExecutions) {
        TreeSet<String> scopesToCollect = new TreeSet<String>();
        TreeSet<String> scopesToResolve = new TreeSet<String>();
        for (MojoExecution mojoExecution : mojoExecutions) {
            String scopeToResolve;
            MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
            String scopeToCollect = mojoDescriptor.getDependencyCollectionRequired();
            if (StringUtils.isNotEmpty(scopeToCollect)) {
                scopesToCollect.add(scopeToCollect);
            }
            if (!StringUtils.isNotEmpty(scopeToResolve = mojoDescriptor.getDependencyResolutionRequired())) continue;
            scopesToResolve.add(scopeToResolve);
        }
        this.logger.debug("Dependencies (collect): " + scopesToCollect);
        this.logger.debug("Dependencies (resolve): " + scopesToResolve);
    }
}

