/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.lifecycle.internal;

import java.util.Collection;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.MojoExecutionConfigurator;
import org.jetbrains.kotlin.org.apache.maven.model.Plugin;
import org.jetbrains.kotlin.org.apache.maven.model.PluginExecution;
import org.jetbrains.kotlin.org.apache.maven.plugin.MojoExecution;
import org.jetbrains.kotlin.org.apache.maven.project.MavenProject;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Component;
import org.jetbrains.kotlin.org.codehaus.plexus.util.StringUtils;
import org.jetbrains.kotlin.org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=MojoExecutionConfigurator.class)
public class DefaultMojoExecutionConfigurator
implements MojoExecutionConfigurator {
    @Override
    public void configure(MavenProject project, MojoExecution mojoExecution, boolean allowPluginLevelConfig) {
        String a;
        String g2 = mojoExecution.getPlugin().getGroupId();
        Plugin plugin = this.findPlugin(g2, a = mojoExecution.getPlugin().getArtifactId(), project.getBuildPlugins());
        if (plugin == null && project.getPluginManagement() != null) {
            plugin = this.findPlugin(g2, a, project.getPluginManagement().getPlugins());
        }
        if (plugin != null) {
            PluginExecution pluginExecution = this.findPluginExecution(mojoExecution.getExecutionId(), plugin.getExecutions());
            Xpp3Dom pomConfiguration = null;
            if (pluginExecution != null) {
                pomConfiguration = (Xpp3Dom)pluginExecution.getConfiguration();
            } else if (allowPluginLevelConfig) {
                pomConfiguration = (Xpp3Dom)plugin.getConfiguration();
            }
            Xpp3Dom mojoConfiguration = pomConfiguration != null ? new Xpp3Dom(pomConfiguration) : null;
            mojoConfiguration = Xpp3Dom.mergeXpp3Dom(mojoExecution.getConfiguration(), mojoConfiguration);
            mojoExecution.setConfiguration(mojoConfiguration);
        }
    }

    private Plugin findPlugin(String groupId, String artifactId, Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!artifactId.equals(plugin.getArtifactId()) || !groupId.equals(plugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }

    private PluginExecution findPluginExecution(String executionId, Collection<PluginExecution> executions) {
        if (StringUtils.isNotEmpty(executionId)) {
            for (PluginExecution execution : executions) {
                if (!executionId.equals(execution.getId())) continue;
                return execution;
            }
        }
        return null;
    }
}

