/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.kotlin.org.apache.maven.execution.MavenSession;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.GoalTask;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.LifecyclePluginResolver;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.LifecycleTask;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.TaskSegment;
import org.jetbrains.kotlin.org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.jetbrains.kotlin.org.apache.maven.plugin.MojoNotFoundException;
import org.jetbrains.kotlin.org.apache.maven.plugin.PluginDescriptorParsingException;
import org.jetbrains.kotlin.org.apache.maven.plugin.PluginNotFoundException;
import org.jetbrains.kotlin.org.apache.maven.plugin.PluginResolutionException;
import org.jetbrains.kotlin.org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.jetbrains.kotlin.org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.jetbrains.kotlin.org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.jetbrains.kotlin.org.apache.maven.project.MavenProject;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Component;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Requirement;
import org.jetbrains.kotlin.org.codehaus.plexus.util.StringUtils;

@Component(role=LifecycleTaskSegmentCalculator.class)
public class DefaultLifecycleTaskSegmentCalculator
implements LifecycleTaskSegmentCalculator {
    @Requirement
    private MojoDescriptorCreator mojoDescriptorCreator;
    @Requirement
    private LifecyclePluginResolver lifecyclePluginResolver;

    @Override
    public List<TaskSegment> calculateTaskSegments(MavenSession session) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException, LifecyclePhaseNotFoundException, LifecycleNotFoundException {
        MavenProject rootProject = session.getTopLevelProject();
        List<String> tasks = session.getGoals();
        if ((tasks == null || tasks.isEmpty()) && !StringUtils.isEmpty(rootProject.getDefaultGoal())) {
            tasks = Arrays.asList(StringUtils.split(rootProject.getDefaultGoal()));
        }
        return this.calculateTaskSegments(session, tasks);
    }

    @Override
    public List<TaskSegment> calculateTaskSegments(MavenSession session, List<String> tasks) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginVersionResolutionException {
        ArrayList<TaskSegment> taskSegments = new ArrayList<TaskSegment>(tasks.size());
        TaskSegment currentSegment = null;
        for (String task : tasks) {
            if (this.isGoalSpecification(task)) {
                boolean aggregating;
                this.lifecyclePluginResolver.resolveMissingPluginVersions(session.getTopLevelProject(), session);
                MojoDescriptor mojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor(task, session, session.getTopLevelProject());
                boolean bl = aggregating = mojoDescriptor.isAggregator() || !mojoDescriptor.isProjectRequired();
                if (currentSegment == null || currentSegment.isAggregating() != aggregating) {
                    currentSegment = new TaskSegment(aggregating);
                    taskSegments.add(currentSegment);
                }
                currentSegment.getTasks().add(new GoalTask(task));
                continue;
            }
            if (currentSegment == null || currentSegment.isAggregating()) {
                currentSegment = new TaskSegment(false);
                taskSegments.add(currentSegment);
            }
            currentSegment.getTasks().add(new LifecycleTask(task));
        }
        return taskSegments;
    }

    @Override
    public boolean requiresProject(MavenSession session) {
        List<String> goals = session.getGoals();
        if (goals != null) {
            for (String goal : goals) {
                if (this.isGoalSpecification(goal)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isGoalSpecification(String task) {
        return task.indexOf(58) >= 0;
    }
}

