/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.lifecycle.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.kotlin.org.apache.maven.execution.MavenSession;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.ProjectSegment;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.TaskSegment;
import org.jetbrains.kotlin.org.apache.maven.lifecycle.internal.builder.BuilderCommon;
import org.jetbrains.kotlin.org.apache.maven.project.MavenProject;
import org.jetbrains.kotlin.org.codehaus.plexus.component.annotations.Component;

@Component(role=BuildListCalculator.class)
public class BuildListCalculator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectBuildList calculateProjectBuilds(MavenSession session, List<TaskSegment> taskSegments) {
        ArrayList<ProjectSegment> projectBuilds = new ArrayList<ProjectSegment>();
        MavenProject rootProject = session.getTopLevelProject();
        for (TaskSegment taskSegment : taskSegments) {
            List<MavenProject> projects = taskSegment.isAggregating() ? Collections.singletonList(rootProject) : session.getProjects();
            for (MavenProject project : projects) {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                try {
                    BuilderCommon.attachToThread(project);
                    MavenSession copiedSession = session.clone();
                    copiedSession.setCurrentProject(project);
                    projectBuilds.add(new ProjectSegment(project, taskSegment, copiedSession));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(tccl);
                }
            }
        }
        return new ProjectBuildList(projectBuilds);
    }
}

