/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.execution;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.kotlin.org.apache.maven.execution.BuildSummary;
import org.jetbrains.kotlin.org.apache.maven.execution.MavenExecutionResult;
import org.jetbrains.kotlin.org.apache.maven.project.DependencyResolutionResult;
import org.jetbrains.kotlin.org.apache.maven.project.MavenProject;

public class DefaultMavenExecutionResult
implements MavenExecutionResult {
    private MavenProject project;
    private List<MavenProject> topologicallySortedProjects = Collections.emptyList();
    private DependencyResolutionResult dependencyResolutionResult;
    private final List<Throwable> exceptions = new CopyOnWriteArrayList<Throwable>();
    private final Map<MavenProject, BuildSummary> buildSummaries = Collections.synchronizedMap(new IdentityHashMap());

    @Override
    public MavenExecutionResult setProject(MavenProject project) {
        this.project = project;
        return this;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public MavenExecutionResult setTopologicallySortedProjects(List<MavenProject> topologicallySortedProjects) {
        this.topologicallySortedProjects = topologicallySortedProjects;
        return this;
    }

    @Override
    public List<MavenProject> getTopologicallySortedProjects() {
        return null == this.topologicallySortedProjects ? Collections.emptyList() : Collections.unmodifiableList(this.topologicallySortedProjects);
    }

    @Override
    public DependencyResolutionResult getDependencyResolutionResult() {
        return this.dependencyResolutionResult;
    }

    @Override
    public MavenExecutionResult setDependencyResolutionResult(DependencyResolutionResult dependencyResolutionResult) {
        this.dependencyResolutionResult = dependencyResolutionResult;
        return this;
    }

    @Override
    public List<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    public MavenExecutionResult addException(Throwable t) {
        this.exceptions.add(t);
        return this;
    }

    @Override
    public boolean hasExceptions() {
        return !this.getExceptions().isEmpty();
    }

    @Override
    public BuildSummary getBuildSummary(MavenProject project) {
        return this.buildSummaries.get(project);
    }

    @Override
    public void addBuildSummary(BuildSummary summary) {
        this.buildSummaries.put(summary.getProject(), summary);
    }
}

