/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.kotlin.org.apache.commons.io.file.Counters;
import org.jetbrains.kotlin.org.apache.commons.io.file.CountingPathVisitor;
import org.jetbrains.kotlin.org.apache.commons.io.file.DeleteOption;
import org.jetbrains.kotlin.org.apache.commons.io.file.PathUtils;
import org.jetbrains.kotlin.org.apache.commons.io.file.StandardDeleteOption;

public class DeletingPathVisitor
extends CountingPathVisitor {
    private final String[] skip;
    private final boolean overrideReadOnly;
    private final LinkOption[] linkOptions;

    public static DeletingPathVisitor withBigIntegerCounters() {
        return new DeletingPathVisitor(Counters.bigIntegerPathCounters(), new String[0]);
    }

    public static DeletingPathVisitor withLongCounters() {
        return new DeletingPathVisitor(Counters.longPathCounters(), new String[0]);
    }

    public DeletingPathVisitor(Counters.PathCounters pathCounter, DeleteOption[] deleteOption, String ... skip) {
        this(pathCounter, PathUtils.noFollowLinkOptionArray(), deleteOption, skip);
    }

    public DeletingPathVisitor(Counters.PathCounters pathCounter, LinkOption[] linkOptions, DeleteOption[] deleteOption, String ... skip) {
        super(pathCounter);
        Object[] temp = skip != null ? (String[])skip.clone() : EMPTY_STRING_ARRAY;
        Arrays.sort(temp);
        this.skip = temp;
        this.overrideReadOnly = StandardDeleteOption.overrideReadOnly(deleteOption);
        this.linkOptions = linkOptions == null ? PathUtils.noFollowLinkOptionArray() : (LinkOption[])linkOptions.clone();
    }

    public DeletingPathVisitor(Counters.PathCounters pathCounter, String ... skip) {
        this(pathCounter, PathUtils.EMPTY_DELETE_OPTION_ARRAY, skip);
    }

    private boolean accept(Path path) {
        return Arrays.binarySearch(this.skip, PathUtils.getFileNameString(path)) < 0;
    }

    @Override
    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (!super.equals(obj2)) {
            return false;
        }
        if (this.getClass() != obj2.getClass()) {
            return false;
        }
        DeletingPathVisitor other = (DeletingPathVisitor)obj2;
        return this.overrideReadOnly == other.overrideReadOnly && Arrays.equals(this.skip, other.skip);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.skip);
        result2 = 31 * result2 + Objects.hash(this.overrideReadOnly);
        return result2;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir2, IOException exc) throws IOException {
        if (PathUtils.isEmptyDirectory(dir2)) {
            Files.deleteIfExists(dir2);
        }
        return super.postVisitDirectory(dir2, exc);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) throws IOException {
        super.preVisitDirectory(dir2, attrs);
        return this.accept(dir2) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.accept(file)) {
            if (Files.exists(file, this.linkOptions)) {
                if (this.overrideReadOnly) {
                    PathUtils.setReadOnly(file, false, this.linkOptions);
                }
                Files.deleteIfExists(file);
            }
            if (Files.isSymbolicLink(file)) {
                try {
                    Files.delete(file);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
        }
        this.updateFileCounters(file, attrs);
        return FileVisitResult.CONTINUE;
    }
}

