/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.report;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.FileReportSettings;
import org.jetbrains.kotlin.build.report.HttpReportSettings;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.build.report.metrics.ValueType;
import org.jetbrains.kotlin.build.report.statistics.BuildFinishStatisticsData;
import org.jetbrains.kotlin.build.report.statistics.BuildStartParameters;
import org.jetbrains.kotlin.build.report.statistics.FormattingUtilsKt;
import org.jetbrains.kotlin.build.report.statistics.HttpReportParameters;
import org.jetbrains.kotlin.build.report.statistics.HttpReportService;
import org.jetbrains.kotlin.build.report.statistics.JsonReportService;
import org.jetbrains.kotlin.build.report.statistics.StatTag;
import org.jetbrains.kotlin.build.report.statistics.file.ReadableFileReportData;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.gradle.dsl.KotlinVersion;
import org.jetbrains.kotlin.gradle.internal.report.BuildScanApi;
import org.jetbrains.kotlin.gradle.plugin.statistics.GradleFileReportService;
import org.jetbrains.kotlin.gradle.report.BuildReportParameters;
import org.jetbrains.kotlin.gradle.report.BuildReportsService;
import org.jetbrains.kotlin.gradle.report.BuildScanSettings;
import org.jetbrains.kotlin.gradle.report.GradleLoggerAdapter;
import org.jetbrains.kotlin.gradle.report.MetricsWriter;
import org.jetbrains.kotlin.gradle.report.ReportDataUtilKt;
import org.jetbrains.kotlin.gradle.report.ReportingSettings;
import org.jetbrains.kotlin.gradle.report.TaskRecord;
import org.jetbrains.kotlin.gradle.report.data.BuildExecutionData;
import org.jetbrains.kotlin.gradle.report.data.BuildOperationRecord;
import org.jetbrains.kotlin.gradle.report.data.GradleCompileStatisticsData;
import org.jetbrains.kotlin.gradle.utils.CompilerOptionsKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 F2\u00020\u0001:\u0001FB\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ-\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ \u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010%\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0004H\u0002J\u0015\u0010'\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b(J \u0010)\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J*\u0010*\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010\u001a\u001a\u00020\u001bJ\u001f\u0010-\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010.\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b/J\u001e\u00100\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 2\u0006\u00101\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010\"\u001a\u00020#H\u0002J \u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u00020\u0014H\u0002J\u0012\u00107\u001a\u0004\u0018\u0001082\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u00109\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020:H\u0002J\u001e\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\bH\u0002J>\u0010>\u001a\b\u0012\u0004\u0012\u00020#0,2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020@2\u0010\b\u0002\u0010A\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010BH\u0002J\u0014\u0010C\u001a\u00020D*\u00020D2\u0006\u0010E\u001a\u00020@H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildReportsService;", "", "()V", "buildUuid", "", "getBuildUuid$kotlin_gradle_plugin_common", "()Ljava/lang/String;", "customValues", "", "httpReportService", "Lorg/jetbrains/kotlin/build/report/statistics/HttpReportService;", "log", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "loggerAdapter", "Lorg/jetbrains/kotlin/gradle/report/GradleLoggerAdapter;", "startTime", "", "tags", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/build/report/statistics/StatTag;", "addBuildScanReport", "", "buildOperationRecords", "", "Lorg/jetbrains/kotlin/gradle/report/data/BuildOperationRecord;", "parameters", "Lorg/jetbrains/kotlin/gradle/report/BuildReportParameters;", "buildScan", "Lorg/jetbrains/kotlin/gradle/internal/report/BuildScanApi;", "addBuildScanReport$kotlin_gradle_plugin_common", "event", "Lorg/gradle/tooling/events/task/TaskFinishEvent;", "buildOperationRecord", "data", "Lorg/jetbrains/kotlin/gradle/report/data/GradleCompileStatisticsData;", "customValuesLimit", "addBuildScanValue", "customValue", "addCollectedTags", "addCollectedTags$kotlin_gradle_plugin_common", "addHttpReport", "close", "failureMessages", "", "initBuildScanTags", "label", "initBuildScanTags$kotlin_gradle_plugin_common", "onFinish", "buildOperation", "readableString", "replaceWithCombinedTag", "firstTag", "secondTag", "combinedTag", "reportBuildFinish", "Lorg/jetbrains/kotlin/build/report/statistics/BuildFinishStatisticsData;", "reportTryNextToConsole", "Lorg/jetbrains/kotlin/gradle/report/data/BuildExecutionData;", "splitStringIfNeed", "str", "lengthLimit", "transformOperationRecordsToCompileStatisticsData", "onlyKotlinTask", "", "metricsToShow", "", "includeVerboseEnvironment", "Lorg/jetbrains/kotlin/build/report/statistics/BuildStartParameters;", "verboseEnvironment", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nBuildReportsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildReportsService.kt\norg/jetbrains/kotlin/gradle/report/BuildReportsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 Timing.kt\nkotlin/system/TimingKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,428:1\n1053#2:429\n774#2:430\n865#2,2:431\n1611#2,9:433\n1863#2:442\n1864#2:444\n1620#2:445\n1863#2,2:453\n1863#2,2:460\n808#2,11:463\n774#2:474\n865#2,2:475\n1782#2,4:477\n1557#2:481\n1628#2,3:482\n1053#2:485\n1863#2,2:486\n1863#2,2:496\n1#3:443\n1#3:446\n198#4,3:447\n198#4,3:450\n17#5,5:455\n22#5:462\n126#6:488\n153#6,3:489\n126#6:492\n153#6,3:493\n*S KotlinDebug\n*F\n+ 1 BuildReportsService.kt\norg/jetbrains/kotlin/gradle/report/BuildReportsService\n*L\n56#1:429\n75#1:430\n75#1:431,2\n104#1:433,9\n104#1:442\n104#1:444\n104#1:445\n233#1:453,2\n242#1:460,2\n273#1:463,11\n274#1:474\n274#1:475,2\n283#1:477,4\n287#1:481\n287#1:482,3\n288#1:485\n288#1:486,2\n370#1:496,2\n104#1:443\n200#1:447,3\n223#1:450,3\n239#1:455,5\n239#1:462\n317#1:488\n317#1:489,3\n318#1:492\n318#1:493,3\n*E\n"})
public final class BuildReportsService {
    @NotNull
    public static final Companion Companion;
    private final Logger log;
    @NotNull
    private final GradleLoggerAdapter loggerAdapter;
    private final long startTime;
    @NotNull
    private final String buildUuid;
    @NotNull
    private final HttpReportService httpReportService;
    @NotNull
    private final LinkedHashSet<StatTag> tags;
    private int customValues;
    public static final int CUSTOM_VALUE_LENGTH_LIMIT = 100000;
    @NotNull
    private static final SimpleDateFormat DATE_FORMATTER;
    @Nullable
    private static final String hostName;

    public BuildReportsService() {
        Logger logger2 = this.log = Logging.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
        this.loggerAdapter = new GradleLoggerAdapter(logger2);
        this.startTime = System.nanoTime();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.buildUuid = string;
        this.httpReportService = new HttpReportService();
        this.tags = new LinkedHashSet();
        this.log.info("Build report service is registered. Unique build id: " + this.buildUuid);
    }

    @NotNull
    public final String getBuildUuid$kotlin_gradle_plugin_common() {
        return this.buildUuid;
    }

    /*
     * WARNING - void declaration
     */
    public final void close(@NotNull Collection<? extends BuildOperationRecord> buildOperationRecords, @NotNull List<String> failureMessages, @NotNull BuildReportParameters parameters) {
        block6: {
            Object it;
            Object object;
            Intrinsics.checkNotNullParameter(buildOperationRecords, (String)"buildOperationRecords");
            Intrinsics.checkNotNullParameter(failureMessages, (String)"failureMessages");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Iterable $this$sortedBy$iv = buildOperationRecords;
            boolean $i$f$sortedBy = false;
            BuildExecutionData buildData = new BuildExecutionData(parameters.getStartParameters(), failureMessages, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    BuildOperationRecord it = (BuildOperationRecord)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getStartTimeMs());
                    it = (BuildOperationRecord)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getStartTimeMs()));
                }
            }));
            ReportingSettings reportingSettings = parameters.getReportingSettings();
            HttpReportParameters httpReportParameters = parameters.getHttpReportParameters();
            if (httpReportParameters != null) {
                object = httpReportParameters;
                it = object;
                boolean bl = false;
                this.httpReportService.sendData(it, (KotlinLogger)this.loggerAdapter, (Function0)new Function0<Object>(this, parameters){
                    final /* synthetic */ BuildReportsService this$0;
                    final /* synthetic */ BuildReportParameters $parameters;
                    {
                        this.this$0 = $receiver;
                        this.$parameters = $parameters;
                        super(0);
                    }

                    public final Object invoke() {
                        return BuildReportsService.access$reportBuildFinish(this.this$0, this.$parameters);
                    }
                });
            }
            FileReportSettings fileReportSettings = reportingSettings.getFileReportSettings();
            if (fileReportSettings != null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                object = fileReportSettings;
                it = object;
                boolean bl = false;
                Iterable iterable = failureMessages;
                BuildStartParameters buildStartParameters = parameters.getStartParameters();
                List list = BuildReportsService.transformOperationRecordsToCompileStatisticsData$default(this, buildOperationRecords, parameters, false, null, 8, null);
                GradleFileReportService gradleFileReportService = new GradleFileReportService(it.getBuildReportDir(), parameters.getProjectName(), it.getIncludeMetricsInReport());
                boolean $i$f$filter = false;
                void var15_15 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it2 = (String)element$iv$iv;
                    boolean bl2 = false;
                    boolean bl3 = ((CharSequence)it2).length() > 0;
                    if (!bl3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 8;
                int n2 = 0;
                List list3 = list2;
                BuildStartParameters buildStartParameters2 = buildStartParameters;
                List list4 = list;
                gradleFileReportService.process(new ReadableFileReportData(list4, buildStartParameters2, list3, n2, n, defaultConstructorMarker), this.loggerAdapter);
            }
            File file = reportingSettings.getSingleOutputFile();
            if (file != null) {
                Object singleOutputFile = object = file;
                boolean bl = false;
                File file2 = ((File)singleOutputFile).getAbsoluteFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"singleOutputFile.absoluteFile");
                MetricsWriter metricsWriter = new MetricsWriter(file2);
                Logger logger2 = this.log;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"log");
                metricsWriter.process(buildData, logger2);
            }
            if (reportingSettings.getExperimentalTryNextConsoleOutput()) {
                this.reportTryNextToConsole(buildData);
            }
            File file3 = reportingSettings.getJsonOutputDir();
            if (file3 != null) {
                object = file3;
                it = object;
                boolean bl = false;
                new JsonReportService((File)it, parameters.getProjectName()).process((Object)buildData, (KotlinLogger)this.loggerAdapter);
            }
            HttpReportParameters httpReportParameters2 = parameters.getHttpReportParameters();
            if (httpReportParameters2 == null) break block6;
            object = httpReportParameters2;
            it = object;
            boolean bl = false;
            this.httpReportService.close(it, (KotlinLogger)this.loggerAdapter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<GradleCompileStatisticsData> transformOperationRecordsToCompileStatisticsData(Collection<? extends BuildOperationRecord> buildOperationRecords, BuildReportParameters parameters, boolean onlyKotlinTask, Set<String> metricsToShow) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = buildOperationRecords;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            GradleCompileStatisticsData it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            BuildOperationRecord it = (BuildOperationRecord)element$iv$iv;
            boolean bl2 = false;
            if (ReportDataUtilKt.prepareData(null, it.getPath(), it.getStartTimeMs(), it.getTotalTimeMs() + it.getStartTimeMs(), parameters.getProjectName(), this.buildUuid, parameters.getLabel(), parameters.getKotlinVersion(), it, onlyKotlinTask, parameters.getAdditionalTags(), metricsToShow) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List transformOperationRecordsToCompileStatisticsData$default(BuildReportsService buildReportsService, Collection collection, BuildReportParameters buildReportParameters, boolean bl, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            set = null;
        }
        return buildReportsService.transformOperationRecordsToCompileStatisticsData(collection, buildReportParameters, bl, set);
    }

    public final void onFinish(@NotNull TaskFinishEvent event, @NotNull BuildOperationRecord buildOperation, @NotNull BuildReportParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)buildOperation, (String)"buildOperation");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.addHttpReport(event, buildOperation, parameters);
    }

    private final BuildFinishStatisticsData reportBuildFinish(BuildReportParameters parameters) {
        String string;
        HttpReportSettings httpReportSettings = parameters.getReportingSettings().getHttpReportSettings();
        if (httpReportSettings == null) {
            this.log.debug("Unable to send build finish event, httpReportSettings is null ");
            Unit it = Unit.INSTANCE;
            boolean bl = false;
            return null;
        }
        HttpReportSettings httpReportSettings2 = httpReportSettings;
        if (httpReportSettings2.getIncludeGitBranchName()) {
            Object object = new String[]{"git", "rev-parse", "--abbrev-ref", "HEAD"};
            Object it = object = new ProcessBuilder((String[])object).directory(parameters.getProjectDir()).start();
            boolean bl = false;
            ((Process)it).waitFor(5L, TimeUnit.SECONDS);
            Object process = object;
            InputStream inputStream = ((Process)process).getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"process.inputStream");
            object = inputStream;
            Charset charset = Charsets.UTF_8;
            string = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)object, charset));
        } else {
            string = "is not set";
        }
        String branchName = string;
        return new BuildFinishStatisticsData(parameters.getProjectName(), this.includeVerboseEnvironment(parameters.getStartParameters(), parameters.getReportingSettings().getHttpReportSettings().getVerboseEnvironment()), this.buildUuid, parameters.getLabel(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTime), null, System.currentTimeMillis(), null, hostName, (Set)this.tags, branchName, 160, null);
    }

    private final BuildStartParameters includeVerboseEnvironment(BuildStartParameters $this$includeVerboseEnvironment, boolean verboseEnvironment) {
        return verboseEnvironment ? $this$includeVerboseEnvironment : new BuildStartParameters($this$includeVerboseEnvironment.getTasks(), $this$includeVerboseEnvironment.getExcludedTasks(), null, CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    private final void addHttpReport(TaskFinishEvent event, BuildOperationRecord buildOperationRecord, BuildReportParameters parameters) {
        block0: {
            HttpReportParameters httpReportParameters;
            HttpReportParameters httpReportParameters2 = parameters.getHttpReportParameters();
            if (httpReportParameters2 == null) break block0;
            HttpReportParameters httpService = httpReportParameters = httpReportParameters2;
            boolean bl = false;
            this.httpReportService.sendData(httpService, (KotlinLogger)this.loggerAdapter, (Function0)new Function0<Object>(event, parameters, this, buildOperationRecord){
                final /* synthetic */ TaskFinishEvent $event;
                final /* synthetic */ BuildReportParameters $parameters;
                final /* synthetic */ BuildReportsService this$0;
                final /* synthetic */ BuildOperationRecord $buildOperationRecord;
                {
                    this.$event = $event;
                    this.$parameters = $parameters;
                    this.this$0 = $receiver;
                    this.$buildOperationRecord = $buildOperationRecord;
                    super(0);
                }

                public final Object invoke() {
                    return ReportDataUtilKt.prepareData$default(this.$event, this.$parameters.getProjectName(), this.this$0.getBuildUuid$kotlin_gradle_plugin_common(), this.$parameters.getLabel(), this.$parameters.getKotlinVersion(), this.$buildOperationRecord, true, this.$parameters.getAdditionalTags(), null, 256, null);
                }
            });
        }
    }

    public final void addBuildScanReport$kotlin_gradle_plugin_common(@NotNull TaskFinishEvent event, @NotNull BuildOperationRecord buildOperationRecord, @NotNull BuildReportParameters parameters, @NotNull BuildScanApi buildScan) {
        block1: {
            GradleCompileStatisticsData gradleCompileStatisticsData;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)buildOperationRecord, (String)"buildOperationRecord");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)buildScan, (String)"buildScan");
            BuildScanSettings buildScanSettings = parameters.getReportingSettings().getBuildScanReportSettings();
            if (buildScanSettings == null) {
                return;
            }
            BuildScanSettings buildScanSettings2 = buildScanSettings;
            boolean $i$f$measureTimeMillisWithResult = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            GradleCompileStatisticsData result$iv = ReportDataUtilKt.prepareData$default(event, parameters.getProjectName(), this.buildUuid, parameters.getLabel(), parameters.getKotlinVersion(), buildOperationRecord, false, null, buildScanSettings2.getMetrics(), 192, null);
            Pair pair = new Pair((Object)(System.currentTimeMillis() - start$iv), (Object)result$iv);
            long collectDataDuration = ((Number)pair.component1()).longValue();
            GradleCompileStatisticsData compileStatData = (GradleCompileStatisticsData)pair.component2();
            this.log.debug("Collect data takes " + collectDataDuration + ": " + compileStatData);
            GradleCompileStatisticsData gradleCompileStatisticsData2 = compileStatData;
            if (gradleCompileStatisticsData2 == null) break block1;
            GradleCompileStatisticsData it = gradleCompileStatisticsData = gradleCompileStatisticsData2;
            boolean bl2 = false;
            this.addBuildScanReport(it, buildScanSettings2.getCustomValueLimit(), buildScan);
        }
    }

    public final void addBuildScanReport$kotlin_gradle_plugin_common(@NotNull Collection<? extends BuildOperationRecord> buildOperationRecords, @NotNull BuildReportParameters parameters, @NotNull BuildScanApi buildScan) {
        Intrinsics.checkNotNullParameter(buildOperationRecords, (String)"buildOperationRecords");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)buildScan, (String)"buildScan");
        BuildScanSettings buildScanSettings = parameters.getReportingSettings().getBuildScanReportSettings();
        if (buildScanSettings == null) {
            return;
        }
        BuildScanSettings buildScanSettings2 = buildScanSettings;
        boolean $i$f$measureTimeMillisWithResult = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        List<GradleCompileStatisticsData> result$iv = this.transformOperationRecordsToCompileStatisticsData(buildOperationRecords, parameters, true, buildScanSettings2.getMetrics());
        Pair pair = new Pair((Object)(System.currentTimeMillis() - start$iv), result$iv);
        long collectDataDuration = ((Number)pair.component1()).longValue();
        List compileStatData = (List)pair.component2();
        this.log.debug("Collect data takes " + collectDataDuration + ": " + compileStatData);
        Iterable $this$forEach$iv = compileStatData;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleCompileStatisticsData it = (GradleCompileStatisticsData)element$iv;
            boolean bl2 = false;
            this.addBuildScanReport(it, buildScanSettings2.getCustomValueLimit(), buildScan);
        }
    }

    private final void addBuildScanReport(GradleCompileStatisticsData data, int customValuesLimit, BuildScanApi buildScan) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.tags.addAll((Collection<StatTag>)data.getTags());
        if (this.customValues < customValuesLimit) {
            Iterable $this$forEach$iv = this.readableString(data);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (this.customValues < customValuesLimit) {
                    this.addBuildScanValue(buildScan, data, it);
                    continue;
                }
                this.log.debug("Can't add any more custom values into build scan. Statistic data for " + data.getTaskName() + " was cut due to custom values limit.");
            }
        } else {
            this.log.debug("Can't add any more custom values into build scan.");
        }
        long elapsedTime = System.currentTimeMillis() - start$iv;
        this.log.debug("Report statistic to build scan takes " + elapsedTime + " ms");
    }

    private final void addBuildScanValue(BuildScanApi buildScan, GradleCompileStatisticsData data, String customValue) {
        buildScan.value(data.getTaskName(), customValue);
        int n = this.customValues;
        this.customValues = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportTryNextToConsole(BuildExecutionData data) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = data.getBuildOperationRecord();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TaskRecord)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TaskRecord it = (TaskRecord)element$iv$iv;
            boolean bl = false;
            if (!(it.isFromKotlinPlugin() && it.getKotlinLanguageVersion() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tasksData = (List)destination$iv$iv;
        this.log.warn("##### 'kotlin.experimental.tryNext' results #####");
        if (tasksData.isEmpty()) {
            this.log.warn("No Kotlin compilation tasks have been run");
            this.log.warn("#####");
        } else {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Object element$iv2;
            int n;
            Iterable $this$count$iv = tasksData;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv2 : $this$count$iv) {
                    TaskRecord it = (TaskRecord)element$iv2;
                    boolean bl = false;
                    if (!(it.getKotlinLanguageVersion() != null && it.getKotlinLanguageVersion().compareTo((Enum)CompilerOptionsKt.getNextKotlinLanguageVersion(KotlinVersion.Companion)) >= 0) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int tasksCountWithKotlinNext = n;
            int taskWithNextPercent = tasksCountWithKotlinNext * 100 / ((Collection)tasksData).size();
            Iterable $this$map$iv = tasksData;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TaskRecord taskRecord = (TaskRecord)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                KotlinVersion kotlinVersion = it.getKotlinLanguageVersion();
                collection.add(TuplesKt.to((Object)it.getPath(), (Object)(kotlinVersion != null ? kotlinVersion.getVersion() : null)));
            }
            List statsData = (List)destination$iv$iv2;
            Iterable $this$sortedBy$iv = statsData;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                    it = (Pair)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                Pair record = (Pair)element$iv3;
                boolean bl = false;
                this.log.warn((String)record.getFirst() + ": " + (String)record.getSecond() + " language version");
            }
            this.log.warn("##### " + taskWithNextPercent + "% (" + tasksCountWithKotlinNext + '/' + ((Collection)tasksData).size() + ") tasks have been compiled with Kotlin " + CompilerOptionsKt.getNextKotlinLanguageVersion(KotlinVersion.Companion).getVersion() + " #####");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> readableString(GradleCompileStatisticsData data) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Object object;
        StringBuilder readableString2 = new StringBuilder();
        if (data.getNonIncrementalAttributes().isEmpty()) {
            readableString2.append("Incremental build; ");
            CollectionsKt.joinTo$default((Iterable)data.getChanges(), (Appendable)readableString2, null, (CharSequence)"Changes: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.1.INSTANCE, (int)50, null);
        } else {
            CollectionsKt.joinTo$default((Iterable)data.getNonIncrementalAttributes(), (Appendable)readableString2, null, (CharSequence)"Non incremental build because: [", (CharSequence)"]; ", (int)0, null, (Function1)readableString.2.INSTANCE, (int)50, null);
        }
        String string = data.getKotlinLanguageVersion();
        if (string != null) {
            object = string;
            String it = object;
            boolean bl = false;
            readableString2.append("Kotlin language version: " + it + "; ");
        }
        object = data.getBuildTimesMetrics();
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            GradleBuildTime key = (GradleBuildTime)entry2.getKey();
            long value2 = ((Number)entry2.getValue()).longValue();
            collection.add(key.getReadableString() + ": " + value2 + "ms");
        }
        List timeData = (List)destination$iv$iv;
        Map<GradleBuildPerformanceMetric, Long> $this$map$iv2 = data.getPerformanceMetrics();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
        boolean $i$f$mapTo2 = false;
        Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            String string2;
            Map.Entry item$iv$iv;
            Map.Entry entry3 = item$iv$iv = iterator3.next();
            collection = destination$iv$iv2;
            boolean bl3 = false;
            GradleBuildPerformanceMetric key = (GradleBuildPerformanceMetric)entry3.getKey();
            long value3 = ((Number)entry3.getValue()).longValue();
            switch (WhenMappings.$EnumSwitchMapping$0[key.getType().ordinal()]) {
                case 1: {
                    string2 = key.getReadableString() + ": " + FormattingUtilsKt.formatSize((long)value3);
                    break;
                }
                case 2: {
                    string2 = DATE_FORMATTER.format(value3);
                    break;
                }
                default: {
                    string2 = key.getReadableString() + ": " + value3;
                }
            }
            collection.add(string2);
        }
        List perfData = (List)destination$iv$iv2;
        CollectionsKt.joinTo$default((Iterable)CollectionsKt.union((Iterable)timeData, (Iterable)perfData), (Appendable)readableString2, (CharSequence)",", (CharSequence)"Performance: [", (CharSequence)"]", (int)0, null, null, (int)112, null);
        String string3 = readableString2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readableString.toString()");
        return this.splitStringIfNeed(string3, 100000);
    }

    private final List<String> splitStringIfNeed(String str, int lengthLimit) {
        ArrayList<String> splattedString = new ArrayList<String>();
        String tempStr = str;
        while (tempStr.length() > lengthLimit) {
            String subSequence;
            Intrinsics.checkNotNullExpressionValue((Object)tempStr.substring(lengthLimit), (String)"substring(...)");
            int index = StringsKt.lastIndexOf$default((CharSequence)subSequence, (char)';', (int)0, (boolean)false, (int)6, null);
            if (index == -1 && (index = StringsKt.lastIndexOf$default((CharSequence)subSequence, (char)',', (int)0, (boolean)false, (int)6, null)) == -1) {
                index = lengthLimit;
            }
            String string = tempStr.substring(index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            splattedString.add(string);
            Intrinsics.checkNotNullExpressionValue((Object)tempStr.substring(index), (String)"substring(...)");
        }
        splattedString.add(tempStr);
        return splattedString;
    }

    public final void initBuildScanTags$kotlin_gradle_plugin_common(@NotNull BuildScanApi buildScan, @Nullable String label) {
        block0: {
            String string;
            Intrinsics.checkNotNullParameter((Object)buildScan, (String)"buildScan");
            buildScan.tag(this.buildUuid);
            String string2 = label;
            if (string2 == null) break block0;
            String it = string = string2;
            boolean bl = false;
            buildScan.tag(it);
        }
    }

    public final void addCollectedTags$kotlin_gradle_plugin_common(@NotNull BuildScanApi buildScan) {
        Intrinsics.checkNotNullParameter((Object)buildScan, (String)"buildScan");
        this.replaceWithCombinedTag(StatTag.KOTLIN_1, StatTag.KOTLIN_2, StatTag.KOTLIN_1_AND_2);
        this.replaceWithCombinedTag(StatTag.INCREMENTAL, StatTag.NON_INCREMENTAL, StatTag.INCREMENTAL_AND_NON_INCREMENTAL);
        Iterable $this$forEach$iv = this.tags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StatTag it = (StatTag)element$iv;
            boolean bl = false;
            buildScan.tag(it.getReadableString());
        }
    }

    private final void replaceWithCombinedTag(StatTag firstTag, StatTag secondTag, StatTag combinedTag) {
        boolean containsFirstTag = this.tags.remove(firstTag);
        boolean containsSecondTag = this.tags.remove(secondTag);
        if (containsFirstTag && containsSecondTag) {
            this.tags.add(combinedTag);
        } else if (containsFirstTag) {
            this.tags.add(firstTag);
        } else if (containsSecondTag) {
            this.tags.add(secondTag);
        }
    }

    public static final /* synthetic */ BuildFinishStatisticsData access$reportBuildFinish(BuildReportsService $this, BuildReportParameters parameters) {
        return $this.reportBuildFinish(parameters);
    }

    static {
        String string;
        Companion = new Companion(null);
        DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception _) {
            string = null;
        }
        hostName = string;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/gradle/report/BuildReportsService$Companion;", "", "()V", "CUSTOM_VALUE_LENGTH_LIMIT", "", "DATE_FORMATTER", "Ljava/text/SimpleDateFormat;", "hostName", "", "getHostName", "()Ljava/lang/String;", "getStartParameters", "Lorg/jetbrains/kotlin/build/report/statistics/BuildStartParameters;", "project", "Lorg/gradle/api/Project;", "kotlin-gradle-plugin_common"})
    @SourceDebugExtension(value={"SMAP\nBuildReportsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildReportsService.kt\norg/jetbrains/kotlin/gradle/report/BuildReportsService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,428:1\n1368#2:429\n1454#2,5:430\n126#3:435\n153#3,3:436\n126#3:439\n153#3,3:440\n*S KotlinDebug\n*F\n+ 1 BuildReportsService.kt\norg/jetbrains/kotlin/gradle/report/BuildReportsService$Companion\n*L\n390#1:429\n390#1:430,5\n393#1:435\n393#1:436,3\n394#1:439\n394#1:440,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BuildStartParameters getStartParameters(@NotNull Project project) {
            Collection<String> collection;
            String value2;
            String key;
            Collection<String> collection2;
            Map.Entry entry2;
            Map.Entry item$iv$iv;
            Map $this$mapTo$iv$iv;
            Map $this$map$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StartParameter it = project.getGradle().getStartParameter();
            boolean bl = false;
            List list = it.getTaskRequests();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.taskRequests");
            Object $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                TaskExecutionRequest it2 = (TaskExecutionRequest)element$iv$iv;
                boolean bl2 = false;
                List list2 = it2.getArgs();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.args");
                Iterable list$iv$iv = list2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            Set set = it.getExcludedTaskNames();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"it.excludedTaskNames");
            String string = it.getCurrentDir().getPath();
            Map map = it.getProjectProperties();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"it.projectProperties");
            $this$flatMap$iv = map;
            String string2 = string;
            Set set2 = set;
            List list4 = list3;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry2 = item$iv$iv = (Map.Entry)iterator2.next();
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                key = (String)entry2.getKey();
                value2 = (String)entry2.getValue();
                collection2.add(key + ": " + value2);
            }
            collection2 = (List)destination$iv$iv;
            Map map2 = it.getSystemPropertiesArgs();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"it.systemPropertiesArgs");
            $this$map$iv = map2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                entry2 = item$iv$iv = (Map.Entry)iterator2.next();
                collection = destination$iv$iv;
                boolean bl4 = false;
                key = (String)entry2.getKey();
                value2 = (String)entry2.getValue();
                collection.add(key + ": " + value2);
            }
            Collection<String> collection3 = collection = (List)destination$iv$iv;
            Collection<String> collection4 = collection2;
            String string3 = string2;
            Set set3 = set2;
            List list5 = list4;
            return new BuildStartParameters(list5, set3, string3, collection4, (List)collection3);
        }

        @Nullable
        public final String getHostName() {
            return hostName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.BYTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.MILLISECONDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

