/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks.abi;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.abi.AbiToolsTask;

@DisableCachingByDefault(because="File copy should not be cacheable")
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b!\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0015R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0013\u0010\r\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiUpdateTask;", "Lorg/gradle/api/DefaultTask;", "()V", "actualDir", "Lorg/gradle/api/file/DirectoryProperty;", "getActualDir", "()Lorg/gradle/api/file/DirectoryProperty;", "projectName", "", "getProjectName", "()Ljava/lang/String;", "referenceDir", "getReferenceDir", "rootDir", "getRootDir", "variantName", "Lorg/gradle/api/provider/Property;", "getVariantName", "()Lorg/gradle/api/provider/Property;", "overwrite", "", "overwrite$kotlin_gradle_plugin_common", "Companion", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nKotlinLegacyAbiUpdateTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLegacyAbiUpdateTask.kt\norg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiUpdateTask\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,64:1\n1317#2,2:65\n*S KotlinDebug\n*F\n+ 1 KotlinLegacyAbiUpdateTask.kt\norg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiUpdateTask\n*L\n49#1:65,2\n*E\n"})
public abstract class KotlinLegacyAbiUpdateTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String projectName;
    @NotNull
    private final String rootDir;

    public KotlinLegacyAbiUpdateTask() {
        String string = this.getProject().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        this.projectName = string;
        String string2 = this.getProject().getRootDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.rootDir.absolutePath");
        this.rootDir = string2;
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getReferenceDir();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract DirectoryProperty getActualDir();

    @Input
    @NotNull
    public abstract Property<String> getVariantName();

    @Input
    @NotNull
    public final String getProjectName() {
        return this.projectName;
    }

    @Internal
    @NotNull
    public final String getRootDir() {
        return this.rootDir;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void overwrite$kotlin_gradle_plugin_common() {
        void $this$forEach$iv;
        File actualDir = ((Directory)this.getActualDir().get()).getAsFile();
        File referenceDir = ((Directory)this.getReferenceDir().get()).getAsFile();
        String string = referenceDir.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"referenceDir.absolutePath");
        if (!StringsKt.startsWith$default((String)string, (String)this.rootDir, (boolean)false, (int)2, null)) {
            throw new IllegalStateException("'referenceDir' must be a subdirectory of the build root directory; 'referenceDir' " + referenceDir + ", root directory " + this.rootDir);
        }
        String jvmDumpName = this.projectName + ".api";
        String klibDumpName = this.projectName + ".klib.api";
        Intrinsics.checkNotNullExpressionValue((Object)actualDir, (String)"actualDir");
        Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)actualDir, null, (int)1, null)), (Function1)((Function1)new Function1<File, Boolean>(jvmDumpName, klibDumpName){
            final /* synthetic */ String $jvmDumpName;
            final /* synthetic */ String $klibDumpName;
            {
                this.$jvmDumpName = $jvmDumpName;
                this.$klibDumpName = $klibDumpName;
                super(1);
            }

            public final Boolean invoke(File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return file.isFile() && Intrinsics.areEqual((Object)file.getName(), (Object)this.$jvmDumpName) || Intrinsics.areEqual((Object)file.getName(), (Object)this.$klibDumpName);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File actualDump = (File)element$iv;
            boolean bl = false;
            String relative = FilesKt.toRelativeString((File)actualDump, (File)actualDir);
            Intrinsics.checkNotNullExpressionValue((Object)referenceDir, (String)"referenceDir");
            File referenceDump = FilesKt.resolve((File)referenceDir, (String)relative);
            FilesKt.copyTo$default((File)actualDump, (File)referenceDump, (boolean)true, (int)0, (int)4, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/tasks/abi/KotlinLegacyAbiUpdateTask$Companion;", "", "()V", "nameForVariant", "", "variantName", "kotlin-gradle-plugin_common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String nameForVariant(@NotNull String variantName) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            return AbiToolsTask.Companion.composeTaskName$kotlin_gradle_plugin_common("updateLegacyAbi", variantName);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

