/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.serialization;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.gson.Gson;
import org.jetbrains.kotlin.com.google.gson.GsonBuilder;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.Uklib;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.UklibFragment;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.serialization.IncompatibleUklibFragmentFile;
import org.jetbrains.kotlin.gradle.plugin.mpp.uklibs.serialization.MissingUklibFragmentFile;
import org.jetbrains.kotlin.incremental.FileUtilsKt;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002\u001a4\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00022\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0013\u001a\u00020\u0004*\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"allowRepackingArchivesWithExtensions", "", "", "packDirectory", "", "directory", "Ljava/io/File;", "identifier", "zipOutputStream", "Ljava/util/zip/ZipOutputStream;", "unzip", "zipFilePath", "outputFolderPath", "zipUklibContents", "manifest", "fragmentToArtifact", "", "outputZip", "temporariesDirectory", "serializeToZipArchive", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/Uklib;", "kotlin-gradle-plugin_common"})
@SourceDebugExtension(value={"SMAP\nuklibSerialization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 uklibSerialization.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/serialization/UklibSerializationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,151:1\n1053#2:152\n1557#2:153\n1628#2,3:154\n1557#2:157\n1628#2,3:158\n216#3,2:161\n*S KotlinDebug\n*F\n+ 1 uklibSerialization.kt\norg/jetbrains/kotlin/gradle/plugin/mpp/uklibs/serialization/UklibSerializationKt\n*L\n30#1:152\n33#1:153\n33#1:154,3\n46#1:157\n46#1:158,3\n85#1:161,2\n*E\n"})
public final class UklibSerializationKt {
    @NotNull
    private static final Set<String> allowRepackingArchivesWithExtensions;

    /*
     * WARNING - void declaration
     */
    public static final void serializeToZipArchive(@NotNull Uklib $this$serializeToZipArchive, @NotNull File outputZip, @NotNull File temporariesDirectory) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection<Map> collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$serializeToZipArchive, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)outputZip, (String)"outputZip");
        Intrinsics.checkNotNullParameter((Object)temporariesDirectory, (String)"temporariesDirectory");
        Object object = new Pair[2];
        Iterable $this$sortedBy$iv = $this$serializeToZipArchive.getModule().getFragments();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                UklibFragment it = (UklibFragment)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getIdentifier());
                it = (UklibFragment)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getIdentifier())));
            }
        });
        String string = "fragments";
        int n = 0;
        Object object2 = object;
        Object object3 = new GsonBuilder().setPrettyPrinting().create();
        boolean $i$f$map22 = false;
        void var7_12 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            UklibFragment uklibFragment = (UklibFragment)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"identifier", (Object)it.getIdentifier()), TuplesKt.to((Object)"targets", (Object)CollectionsKt.sorted((Iterable)it.getAttributes()))};
            collection.add(MapsKt.mapOf((Pair[])pairArray));
        }
        collection = (List)destination$iv$iv;
        object2[n] = TuplesKt.to((Object)string, (Object)collection);
        object[1] = TuplesKt.to((Object)"manifestVersion", (Object)$this$serializeToZipArchive.getManifestVersion());
        String manifest = ((Gson)object3).toJson(MapsKt.mapOf((Pair[])object));
        Intrinsics.checkNotNullExpressionValue((Object)manifest, (String)"manifest");
        object = $this$serializeToZipArchive.getModule().getFragments();
        object3 = manifest;
        boolean $i$f$map = false;
        void $i$f$map22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (UklibFragment)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object2.add(TuplesKt.to((Object)it.getIdentifier(), (Object)it.getFile().invoke()));
        }
        UklibSerializationKt.zipUklibContents((String)object3, MapsKt.toMap((Iterable)((List)destination$iv$iv2)), outputZip, temporariesDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void zipUklibContents(String manifest, Map<String, ? extends File> fragmentToArtifact, File outputZip, File temporariesDirectory) {
        Closeable closeable = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputZip)));
        Throwable throwable = null;
        try {
            ZipOutputStream zipOutputStream = (ZipOutputStream)closeable;
            boolean bl = false;
            zipOutputStream.putNextEntry(new ZipEntry("umanifest"));
            String string = manifest;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            ByteStreamsKt.copyTo$default((InputStream)new ByteArrayInputStream(byArray), (OutputStream)zipOutputStream, (int)0, (int)2, null);
            Map<String, ? extends File> $this$forEach$iv = fragmentToArtifact;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, ? extends File>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, ? extends File> element$iv;
                Map.Entry<String, ? extends File> entry2 = element$iv = iterator2.next();
                boolean bl2 = false;
                String identifier = entry2.getKey();
                File file = entry2.getValue();
                if (!file.exists()) {
                    throw new MissingUklibFragmentFile(file);
                }
                if (file.isDirectory()) {
                    UklibSerializationKt.packDirectory(file, identifier, zipOutputStream);
                    continue;
                }
                if (allowRepackingArchivesWithExtensions.contains(FilesKt.getExtension((File)file))) {
                    File temp = FilesKt.resolve((File)temporariesDirectory, (String)identifier);
                    if (temp.exists()) {
                        FileUtilsKt.deleteDirectoryContents(temp);
                    }
                    temp.mkdirs();
                    UklibSerializationKt.unzip(file, temp);
                    UklibSerializationKt.packDirectory(temp, identifier, zipOutputStream);
                    continue;
                }
                throw new IncompatibleUklibFragmentFile(file);
            }
            zipOutputStream.closeEntry();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void packDirectory(File directory, String identifier, ZipOutputStream zipOutputStream) {
        Files.walk(directory.toPath(), new FileVisitOption[0]).forEach(new Consumer(identifier, directory, zipOutputStream){
            final /* synthetic */ String $identifier;
            final /* synthetic */ File $directory;
            final /* synthetic */ ZipOutputStream $zipOutputStream;
            {
                this.$identifier = $identifier;
                this.$directory = $directory;
                this.$zipOutputStream = $zipOutputStream;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void accept(Path path) {
                StringBuilder stringBuilder = new StringBuilder().append(this.$identifier).append('/');
                File file = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
                ZipEntry zipEntry = new ZipEntry(stringBuilder.append(FilesKt.toRelativeString((File)file, (File)this.$directory)).toString());
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    this.$zipOutputStream.putNextEntry(zipEntry);
                    Closeable closeable = Files.newInputStream(path, new OpenOption[0]);
                    ZipOutputStream zipOutputStream = this.$zipOutputStream;
                    Throwable throwable = null;
                    try {
                        InputStream inputStream = (InputStream)closeable;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
                        long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)zipOutputStream, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    this.$zipOutputStream.closeEntry();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void unzip(File zipFilePath, File outputFolderPath) {
        Closeable closeable = new ZipInputStream(new FileInputStream(zipFilePath));
        Throwable throwable = null;
        try {
            ZipInputStream zipInputStream = (ZipInputStream)closeable;
            boolean bl = false;
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                File newFile = new File(outputFolderPath, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    File file = newFile.getParentFile();
                    if (file != null) {
                        file.mkdirs();
                    }
                    Closeable closeable2 = new FileOutputStream(newFile);
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream fileOutputStream = (FileOutputStream)closeable2;
                        boolean bl2 = false;
                        long l = ByteStreamsKt.copyTo$default((InputStream)zipInputStream, (OutputStream)fileOutputStream, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.closeEntry();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        Object[] objectArray = new String[]{"klib", "jar"};
        allowRepackingArchivesWithExtensions = SetsKt.setOf((Object[])objectArray);
    }
}

