/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp.apple;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Build cache doesn't work with symbolic links")
@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b!\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0011\u0010\u000f\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/apple/SymbolicLinkToFrameworkTask;", "Lorg/gradle/api/DefaultTask;", "()V", "builtProductsDirectory", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getBuiltProductsDirectory", "()Lorg/gradle/api/provider/Property;", "dsymPath", "getDsymPath", "dsymSymbolicLinkPath", "getDsymSymbolicLinkPath", "()Ljava/io/File;", "frameworkPath", "getFrameworkPath", "frameworkSymbolicLinkPath", "getFrameworkSymbolicLinkPath", "shouldDsymLinkExist", "", "getShouldDsymLinkExist", "isSymbolicLinkUpToDate", "linkPath", "Ljava/nio/file/Path;", "destinationPath", "updateSymbolicLink", "", "shouldLinkExist", "writeSymbolicLinks", "kotlin-gradle-plugin_common"})
public abstract class SymbolicLinkToFrameworkTask
extends DefaultTask {
    public SymbolicLinkToFrameworkTask() {
        this.getOutputs().upToDateWhen(new Spec(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isSatisfiedBy(Task it) {
                Path path = this.getFrameworkSymbolicLinkPath().toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"frameworkSymbolicLinkPath.toPath()");
                Path path2 = ((File)this.getFrameworkPath().get()).toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"frameworkPath.get().toPath()");
                boolean frameworkLinkUpToDate = this.isSymbolicLinkUpToDate(path, path2);
                Object object = this.getShouldDsymLinkExist().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"shouldDsymLinkExist.get()");
                if (((Boolean)object).booleanValue()) {
                    if (!frameworkLinkUpToDate) return false;
                    Path path3 = this.getDsymSymbolicLinkPath().toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"dsymSymbolicLinkPath.toPath()");
                    Path path4 = ((File)this.getDsymPath().get()).toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"dsymPath.get().toPath()");
                    if (!this.isSymbolicLinkUpToDate(path3, path4)) return false;
                    return true;
                }
                if (!frameworkLinkUpToDate) return false;
                if (this.getDsymSymbolicLinkPath().exists()) return false;
                return true;
            }
        });
    }

    @Internal
    @NotNull
    public abstract Property<File> getBuiltProductsDirectory();

    @Internal
    @NotNull
    public abstract Property<File> getFrameworkPath();

    @Internal
    @NotNull
    public abstract Property<File> getDsymPath();

    @Input
    @NotNull
    public abstract Property<Boolean> getShouldDsymLinkExist();

    @Internal
    @NotNull
    public final File getFrameworkSymbolicLinkPath() {
        Object object = this.getBuiltProductsDirectory().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builtProductsDirectory.get()");
        File file = (File)object;
        String string = ((File)this.getFrameworkPath().get()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"frameworkPath.get().name");
        return FilesKt.resolve((File)file, (String)string);
    }

    @Internal
    @NotNull
    public final File getDsymSymbolicLinkPath() {
        Object object = this.getBuiltProductsDirectory().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builtProductsDirectory.get()");
        File file = (File)object;
        String string = ((File)this.getDsymPath().get()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dsymPath.get().name");
        return FilesKt.resolve((File)file, (String)string);
    }

    private final boolean isSymbolicLinkUpToDate(Path linkPath, Path destinationPath) {
        return Files.isSymbolicLink(linkPath) && Intrinsics.areEqual((Object)Files.readSymbolicLink(linkPath), (Object)destinationPath);
    }

    @TaskAction
    public final void writeSymbolicLinks() {
        Path path = this.getFrameworkSymbolicLinkPath().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"frameworkSymbolicLinkPath.toPath()");
        Path path2 = ((File)this.getFrameworkPath().get()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"frameworkPath.get().toPath()");
        this.updateSymbolicLink(path, path2, true);
        Path path3 = this.getDsymSymbolicLinkPath().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"dsymSymbolicLinkPath.toPath()");
        Path path4 = ((File)this.getDsymPath().get()).toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"dsymPath.get().toPath()");
        Object object = this.getShouldDsymLinkExist().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"shouldDsymLinkExist.get()");
        this.updateSymbolicLink(path3, path4, (Boolean)object);
    }

    private final void updateSymbolicLink(Path linkPath, Path destinationPath, boolean shouldLinkExist) {
        if (Files.isSymbolicLink(linkPath)) {
            Files.deleteIfExists(linkPath);
        } else if (Files.exists(linkPath, new LinkOption[0])) {
            File file = linkPath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"linkPath.toFile()");
            FilesKt.deleteRecursively((File)file);
        }
        if (shouldLinkExist) {
            Files.createSymbolicLink(linkPath, destinationPath, new FileAttribute[0]);
        }
    }
}

