/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.annotations.GwtCompatible;
import org.jetbrains.kotlin.com.google.common.annotations.GwtIncompatible;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.collect.ParametricNullness;
import org.jetbrains.kotlin.com.google.common.collect.Platform;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class ObjectArrays {
    private ObjectArrays() {
    }

    @GwtIncompatible
    public static <T> T[] newArray(Class<@NonNull T> type, int length) {
        return (Object[])Array.newInstance(type, length);
    }

    public static <T> T[] newArray(T[] reference2, int length) {
        return Platform.newArray(reference2, length);
    }

    @GwtIncompatible
    public static <T> T[] concat(T[] first, T[] second, Class<@NonNull T> type) {
        T[] result2 = ObjectArrays.newArray(type, first.length + second.length);
        System.arraycopy(first, 0, result2, 0, first.length);
        System.arraycopy(second, 0, result2, first.length, second.length);
        return result2;
    }

    public static <T> T[] concat(@ParametricNullness T element, T[] array2) {
        T[] result2 = ObjectArrays.newArray(array2, array2.length + 1);
        result2[0] = element;
        System.arraycopy(array2, 0, result2, 1, array2.length);
        return result2;
    }

    public static <T> T[] concat(T[] array2, @ParametricNullness T element) {
        T[] result2 = Arrays.copyOf(array2, array2.length + 1);
        result2[array2.length] = element;
        return result2;
    }

    static <T> T[] toArrayImpl(Collection<?> c, T[] array2) {
        int size = c.size();
        if (array2.length < size) {
            array2 = ObjectArrays.newArray(array2, size);
        }
        ObjectArrays.fillArray(c, array2);
        if (array2.length > size) {
            @Nullable T[] unsoundlyCovariantArray = array2;
            unsoundlyCovariantArray[size] = null;
        }
        return array2;
    }

    static <T> T[] toArrayImpl(@Nullable Object[] src, int offset, int len, T[] dst) {
        Preconditions.checkPositionIndexes(offset, offset + len, src.length);
        if (dst.length < len) {
            dst = ObjectArrays.newArray(dst, len);
        } else if (dst.length > len) {
            T[] unsoundlyCovariantArray = dst;
            unsoundlyCovariantArray[len] = null;
        }
        System.arraycopy(src, offset, dst, 0, len);
        return dst;
    }

    static @Nullable Object[] toArrayImpl(Collection<?> c) {
        return ObjectArrays.fillArray(c, new Object[c.size()]);
    }

    static @Nullable Object[] copyAsObjectArray(@Nullable Object[] elements, int offset, int length) {
        Preconditions.checkPositionIndexes(offset, offset + length, elements.length);
        if (length == 0) {
            return new Object[0];
        }
        @Nullable Object[] result2 = new Object[length];
        System.arraycopy(elements, offset, result2, 0, length);
        return result2;
    }

    @CanIgnoreReturnValue
    private static @Nullable Object[] fillArray(Iterable<?> elements, @Nullable Object[] array2) {
        int i2 = 0;
        for (Object element : elements) {
            array2[i2++] = element;
        }
        return array2;
    }

    static void swap(Object[] array2, int i2, int j) {
        Object temp = array2[i2];
        array2[i2] = array2[j];
        array2[j] = temp;
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object ... array2) {
        return ObjectArrays.checkElementsNotNull(array2, array2.length);
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object[] array2, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            ObjectArrays.checkElementNotNull(array2[i2], i2);
        }
        return array2;
    }

    @CanIgnoreReturnValue
    static Object checkElementNotNull(Object element, int index) {
        if (element == null) {
            throw new NullPointerException("at index " + index);
        }
        return element;
    }
}

