/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.commons.lang3.builder;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.jetbrains.kotlin.org.apache.commons.lang3.ClassUtils;
import org.jetbrains.kotlin.org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.kotlin.org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.kotlin.org.apache.commons.lang3.StringUtils;

public abstract class ToStringStyle
implements Serializable {
    private static final long serialVersionUID = -2587890625525655916L;
    public static final ToStringStyle DEFAULT_STYLE = new DefaultToStringStyle();
    public static final ToStringStyle MULTI_LINE_STYLE = new MultiLineToStringStyle();
    public static final ToStringStyle NO_FIELD_NAMES_STYLE = new NoFieldNameToStringStyle();
    public static final ToStringStyle SHORT_PREFIX_STYLE = new ShortPrefixToStringStyle();
    public static final ToStringStyle SIMPLE_STYLE = new SimpleToStringStyle();
    public static final ToStringStyle NO_CLASS_NAME_STYLE = new NoClassNameToStringStyle();
    public static final ToStringStyle JSON_STYLE = new JsonToStringStyle();
    private static final ThreadLocal<WeakHashMap<Object, Object>> REGISTRY = new ThreadLocal();
    private boolean useFieldNames = true;
    private boolean useClassName = true;
    private boolean useShortClassName;
    private boolean useIdentityHashCode = true;
    private String contentStart = "[";
    private String contentEnd = "]";
    private String fieldNameValueSeparator = "=";
    private boolean fieldSeparatorAtStart;
    private boolean fieldSeparatorAtEnd;
    private String fieldSeparator = ",";
    private String arrayStart = "{";
    private String arraySeparator = ",";
    private boolean arrayContentDetail = true;
    private String arrayEnd = "}";
    private boolean defaultFullDetail = true;
    private String nullText = "<null>";
    private String sizeStartText = "<size=";
    private String sizeEndText = ">";
    private String summaryObjectStartText = "<";
    private String summaryObjectEndText = ">";

    public static Map<Object, Object> getRegistry() {
        return REGISTRY.get();
    }

    static boolean isRegistered(Object value2) {
        Map<Object, Object> m = ToStringStyle.getRegistry();
        return m != null && m.containsKey(value2);
    }

    static void register(Object value2) {
        if (value2 != null) {
            Map<Object, Object> m = ToStringStyle.getRegistry();
            if (m == null) {
                REGISTRY.set(new WeakHashMap());
            }
            ToStringStyle.getRegistry().put(value2, null);
        }
    }

    static void unregister(Object value2) {
        Map<Object, Object> m;
        if (value2 != null && (m = ToStringStyle.getRegistry()) != null) {
            m.remove(value2);
            if (m.isEmpty()) {
                REGISTRY.remove();
            }
        }
    }

    protected ToStringStyle() {
    }

    public void append(StringBuffer buffer, String fieldName, boolean value2) {
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, value2);
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, boolean[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array2);
        } else {
            this.appendSummary(buffer, fieldName, array2);
        }
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, byte value2) {
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, value2);
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, byte[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array2);
        } else {
            this.appendSummary(buffer, fieldName, array2);
        }
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, char value2) {
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, value2);
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, char[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array2);
        } else {
            this.appendSummary(buffer, fieldName, array2);
        }
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, double value2) {
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, value2);
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, double[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array2);
        } else {
            this.appendSummary(buffer, fieldName, array2);
        }
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, float value2) {
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, value2);
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, float[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array2);
        } else {
            this.appendSummary(buffer, fieldName, array2);
        }
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, int value2) {
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, value2);
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, int[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array2);
        } else {
            this.appendSummary(buffer, fieldName, array2);
        }
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, long value2) {
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, value2);
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, long[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array2);
        } else {
            this.appendSummary(buffer, fieldName, array2);
        }
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, Object value2, Boolean fullDetail) {
        this.appendFieldStart(buffer, fieldName);
        if (value2 == null) {
            this.appendNullText(buffer, fieldName);
        } else {
            this.appendInternal(buffer, fieldName, value2, this.isFullDetail(fullDetail));
        }
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, Object[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array2);
        } else {
            this.appendSummary(buffer, fieldName, array2);
        }
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, short value2) {
        this.appendFieldStart(buffer, fieldName);
        this.appendDetail(buffer, fieldName, value2);
        this.appendFieldEnd(buffer, fieldName);
    }

    public void append(StringBuffer buffer, String fieldName, short[] array2, Boolean fullDetail) {
        this.appendFieldStart(buffer, fieldName);
        if (array2 == null) {
            this.appendNullText(buffer, fieldName);
        } else if (this.isFullDetail(fullDetail)) {
            this.appendDetail(buffer, fieldName, array2);
        } else {
            this.appendSummary(buffer, fieldName, array2);
        }
        this.appendFieldEnd(buffer, fieldName);
    }

    protected void appendClassName(StringBuffer buffer, Object object) {
        if (this.useClassName && object != null) {
            ToStringStyle.register(object);
            if (this.useShortClassName) {
                buffer.append(this.getShortClassName(object.getClass()));
            } else {
                buffer.append(object.getClass().getName());
            }
        }
    }

    protected void appendContentEnd(StringBuffer buffer) {
        buffer.append(this.contentEnd);
    }

    protected void appendContentStart(StringBuffer buffer) {
        buffer.append(this.contentStart);
    }

    protected void appendCyclicObject(StringBuffer buffer, String fieldName, Object value2) {
        ObjectUtils.identityToString(buffer, value2);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, boolean value2) {
        buffer.append(value2);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, boolean[] array2) {
        buffer.append(this.arrayStart);
        for (int i2 = 0; i2 < array2.length; ++i2) {
            if (i2 > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array2[i2]);
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, byte value2) {
        buffer.append(value2);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, byte[] array2) {
        buffer.append(this.arrayStart);
        for (int i2 = 0; i2 < array2.length; ++i2) {
            if (i2 > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array2[i2]);
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, char value2) {
        buffer.append(value2);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, char[] array2) {
        buffer.append(this.arrayStart);
        for (int i2 = 0; i2 < array2.length; ++i2) {
            if (i2 > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array2[i2]);
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Collection<?> coll) {
        buffer.append(coll);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, double value2) {
        buffer.append(value2);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, double[] array2) {
        buffer.append(this.arrayStart);
        for (int i2 = 0; i2 < array2.length; ++i2) {
            if (i2 > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array2[i2]);
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, float value2) {
        buffer.append(value2);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, float[] array2) {
        buffer.append(this.arrayStart);
        for (int i2 = 0; i2 < array2.length; ++i2) {
            if (i2 > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array2[i2]);
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, int value2) {
        buffer.append(value2);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, int i2, Object item) {
        if (i2 > 0) {
            buffer.append(this.arraySeparator);
        }
        if (item == null) {
            this.appendNullText(buffer, fieldName);
        } else {
            this.appendInternal(buffer, fieldName, item, this.arrayContentDetail);
        }
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, int[] array2) {
        buffer.append(this.arrayStart);
        for (int i2 = 0; i2 < array2.length; ++i2) {
            if (i2 > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array2[i2]);
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, long value2) {
        buffer.append(value2);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, long[] array2) {
        buffer.append(this.arrayStart);
        for (int i2 = 0; i2 < array2.length; ++i2) {
            if (i2 > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array2[i2]);
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Map<?, ?> map2) {
        buffer.append(map2);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Object value2) {
        buffer.append(value2);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Object[] array2) {
        buffer.append(this.arrayStart);
        for (int i2 = 0; i2 < array2.length; ++i2) {
            this.appendDetail(buffer, fieldName, i2, array2[i2]);
        }
        buffer.append(this.arrayEnd);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, short value2) {
        buffer.append(value2);
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, short[] array2) {
        buffer.append(this.arrayStart);
        for (int i2 = 0; i2 < array2.length; ++i2) {
            if (i2 > 0) {
                buffer.append(this.arraySeparator);
            }
            this.appendDetail(buffer, fieldName, array2[i2]);
        }
        buffer.append(this.arrayEnd);
    }

    public void appendEnd(StringBuffer buffer, Object object) {
        if (!this.fieldSeparatorAtEnd) {
            this.removeLastFieldSeparator(buffer);
        }
        this.appendContentEnd(buffer);
        ToStringStyle.unregister(object);
    }

    protected void appendFieldEnd(StringBuffer buffer, String fieldName) {
        this.appendFieldSeparator(buffer);
    }

    protected void appendFieldSeparator(StringBuffer buffer) {
        buffer.append(this.fieldSeparator);
    }

    protected void appendFieldStart(StringBuffer buffer, String fieldName) {
        if (this.useFieldNames && fieldName != null) {
            buffer.append(fieldName);
            buffer.append(this.fieldNameValueSeparator);
        }
    }

    protected void appendIdentityHashCode(StringBuffer buffer, Object object) {
        if (this.isUseIdentityHashCode() && object != null) {
            ToStringStyle.register(object);
            buffer.append('@');
            buffer.append(ObjectUtils.identityHashCodeHex(object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendInternal(StringBuffer buffer, String fieldName, Object value2, boolean detail) {
        if (ToStringStyle.isRegistered(value2) && !(value2 instanceof Number) && !(value2 instanceof Boolean) && !(value2 instanceof Character)) {
            this.appendCyclicObject(buffer, fieldName, value2);
            return;
        }
        ToStringStyle.register(value2);
        try {
            if (value2 instanceof Collection) {
                if (detail) {
                    this.appendDetail(buffer, fieldName, (Collection)value2);
                } else {
                    this.appendSummarySize(buffer, fieldName, ((Collection)value2).size());
                }
            } else if (value2 instanceof Map) {
                if (detail) {
                    this.appendDetail(buffer, fieldName, (Map)value2);
                } else {
                    this.appendSummarySize(buffer, fieldName, ((Map)value2).size());
                }
            } else if (value2 instanceof long[]) {
                if (detail) {
                    this.appendDetail(buffer, fieldName, (long[])value2);
                } else {
                    this.appendSummary(buffer, fieldName, (long[])value2);
                }
            } else if (value2 instanceof int[]) {
                if (detail) {
                    this.appendDetail(buffer, fieldName, (int[])value2);
                } else {
                    this.appendSummary(buffer, fieldName, (int[])value2);
                }
            } else if (value2 instanceof short[]) {
                if (detail) {
                    this.appendDetail(buffer, fieldName, (short[])value2);
                } else {
                    this.appendSummary(buffer, fieldName, (short[])value2);
                }
            } else if (value2 instanceof byte[]) {
                if (detail) {
                    this.appendDetail(buffer, fieldName, (byte[])value2);
                } else {
                    this.appendSummary(buffer, fieldName, (byte[])value2);
                }
            } else if (value2 instanceof char[]) {
                if (detail) {
                    this.appendDetail(buffer, fieldName, (char[])value2);
                } else {
                    this.appendSummary(buffer, fieldName, (char[])value2);
                }
            } else if (value2 instanceof double[]) {
                if (detail) {
                    this.appendDetail(buffer, fieldName, (double[])value2);
                } else {
                    this.appendSummary(buffer, fieldName, (double[])value2);
                }
            } else if (value2 instanceof float[]) {
                if (detail) {
                    this.appendDetail(buffer, fieldName, (float[])value2);
                } else {
                    this.appendSummary(buffer, fieldName, (float[])value2);
                }
            } else if (value2 instanceof boolean[]) {
                if (detail) {
                    this.appendDetail(buffer, fieldName, (boolean[])value2);
                } else {
                    this.appendSummary(buffer, fieldName, (boolean[])value2);
                }
            } else if (ObjectUtils.isArray(value2)) {
                if (detail) {
                    this.appendDetail(buffer, fieldName, (Object[])value2);
                } else {
                    this.appendSummary(buffer, fieldName, (Object[])value2);
                }
            } else if (detail) {
                this.appendDetail(buffer, fieldName, value2);
            } else {
                this.appendSummary(buffer, fieldName, value2);
            }
        }
        finally {
            ToStringStyle.unregister(value2);
        }
    }

    protected void appendNullText(StringBuffer buffer, String fieldName) {
        buffer.append(this.nullText);
    }

    public void appendStart(StringBuffer buffer, Object object) {
        if (object != null) {
            this.appendClassName(buffer, object);
            this.appendIdentityHashCode(buffer, object);
            this.appendContentStart(buffer);
            if (this.fieldSeparatorAtStart) {
                this.appendFieldSeparator(buffer);
            }
        }
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, boolean[] array2) {
        this.appendSummarySize(buffer, fieldName, array2.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, byte[] array2) {
        this.appendSummarySize(buffer, fieldName, array2.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, char[] array2) {
        this.appendSummarySize(buffer, fieldName, array2.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, double[] array2) {
        this.appendSummarySize(buffer, fieldName, array2.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, float[] array2) {
        this.appendSummarySize(buffer, fieldName, array2.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, int[] array2) {
        this.appendSummarySize(buffer, fieldName, array2.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, long[] array2) {
        this.appendSummarySize(buffer, fieldName, array2.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, Object value2) {
        buffer.append(this.summaryObjectStartText);
        buffer.append(this.getShortClassName(value2.getClass()));
        buffer.append(this.summaryObjectEndText);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, Object[] array2) {
        this.appendSummarySize(buffer, fieldName, array2.length);
    }

    protected void appendSummary(StringBuffer buffer, String fieldName, short[] array2) {
        this.appendSummarySize(buffer, fieldName, array2.length);
    }

    protected void appendSummarySize(StringBuffer buffer, String fieldName, int size) {
        buffer.append(this.sizeStartText);
        buffer.append(size);
        buffer.append(this.sizeEndText);
    }

    public void appendSuper(StringBuffer buffer, String superToString) {
        this.appendToString(buffer, superToString);
    }

    public void appendToString(StringBuffer buffer, String toString2) {
        int pos2;
        int pos1;
        if (toString2 != null && (pos1 = toString2.indexOf(this.contentStart) + this.contentStart.length()) != (pos2 = toString2.lastIndexOf(this.contentEnd)) && pos1 >= 0 && pos2 >= 0) {
            if (this.fieldSeparatorAtStart) {
                this.removeLastFieldSeparator(buffer);
            }
            buffer.append(toString2, pos1, pos2);
            this.appendFieldSeparator(buffer);
        }
    }

    protected String getArrayEnd() {
        return this.arrayEnd;
    }

    protected String getArraySeparator() {
        return this.arraySeparator;
    }

    protected String getArrayStart() {
        return this.arrayStart;
    }

    protected String getContentEnd() {
        return this.contentEnd;
    }

    protected String getContentStart() {
        return this.contentStart;
    }

    protected String getFieldNameValueSeparator() {
        return this.fieldNameValueSeparator;
    }

    protected String getFieldSeparator() {
        return this.fieldSeparator;
    }

    protected String getNullText() {
        return this.nullText;
    }

    protected String getShortClassName(Class<?> cls) {
        return ClassUtils.getShortClassName(cls);
    }

    protected String getSizeEndText() {
        return this.sizeEndText;
    }

    protected String getSizeStartText() {
        return this.sizeStartText;
    }

    protected String getSummaryObjectEndText() {
        return this.summaryObjectEndText;
    }

    protected String getSummaryObjectStartText() {
        return this.summaryObjectStartText;
    }

    protected boolean isArrayContentDetail() {
        return this.arrayContentDetail;
    }

    protected boolean isDefaultFullDetail() {
        return this.defaultFullDetail;
    }

    protected boolean isFieldSeparatorAtEnd() {
        return this.fieldSeparatorAtEnd;
    }

    protected boolean isFieldSeparatorAtStart() {
        return this.fieldSeparatorAtStart;
    }

    protected boolean isFullDetail(Boolean fullDetailRequest) {
        if (fullDetailRequest == null) {
            return this.defaultFullDetail;
        }
        return fullDetailRequest;
    }

    protected boolean isUseClassName() {
        return this.useClassName;
    }

    protected boolean isUseFieldNames() {
        return this.useFieldNames;
    }

    protected boolean isUseIdentityHashCode() {
        return this.useIdentityHashCode;
    }

    protected boolean isUseShortClassName() {
        return this.useShortClassName;
    }

    protected void reflectionAppendArrayDetail(StringBuffer buffer, String fieldName, Object array2) {
        buffer.append(this.arrayStart);
        int length = Array.getLength(array2);
        for (int i2 = 0; i2 < length; ++i2) {
            this.appendDetail(buffer, fieldName, i2, Array.get(array2, i2));
        }
        buffer.append(this.arrayEnd);
    }

    protected void removeLastFieldSeparator(StringBuffer buffer) {
        if (StringUtils.endsWith(buffer, this.fieldSeparator)) {
            buffer.setLength(buffer.length() - this.fieldSeparator.length());
        }
    }

    protected void setArrayContentDetail(boolean arrayContentDetail) {
        this.arrayContentDetail = arrayContentDetail;
    }

    protected void setArrayEnd(String arrayEnd) {
        if (arrayEnd == null) {
            arrayEnd = "";
        }
        this.arrayEnd = arrayEnd;
    }

    protected void setArraySeparator(String arraySeparator) {
        if (arraySeparator == null) {
            arraySeparator = "";
        }
        this.arraySeparator = arraySeparator;
    }

    protected void setArrayStart(String arrayStart) {
        if (arrayStart == null) {
            arrayStart = "";
        }
        this.arrayStart = arrayStart;
    }

    protected void setContentEnd(String contentEnd) {
        if (contentEnd == null) {
            contentEnd = "";
        }
        this.contentEnd = contentEnd;
    }

    protected void setContentStart(String contentStart) {
        if (contentStart == null) {
            contentStart = "";
        }
        this.contentStart = contentStart;
    }

    protected void setDefaultFullDetail(boolean defaultFullDetail) {
        this.defaultFullDetail = defaultFullDetail;
    }

    protected void setFieldNameValueSeparator(String fieldNameValueSeparator) {
        if (fieldNameValueSeparator == null) {
            fieldNameValueSeparator = "";
        }
        this.fieldNameValueSeparator = fieldNameValueSeparator;
    }

    protected void setFieldSeparator(String fieldSeparator) {
        if (fieldSeparator == null) {
            fieldSeparator = "";
        }
        this.fieldSeparator = fieldSeparator;
    }

    protected void setFieldSeparatorAtEnd(boolean fieldSeparatorAtEnd) {
        this.fieldSeparatorAtEnd = fieldSeparatorAtEnd;
    }

    protected void setFieldSeparatorAtStart(boolean fieldSeparatorAtStart) {
        this.fieldSeparatorAtStart = fieldSeparatorAtStart;
    }

    protected void setNullText(String nullText) {
        if (nullText == null) {
            nullText = "";
        }
        this.nullText = nullText;
    }

    protected void setSizeEndText(String sizeEndText) {
        if (sizeEndText == null) {
            sizeEndText = "";
        }
        this.sizeEndText = sizeEndText;
    }

    protected void setSizeStartText(String sizeStartText) {
        if (sizeStartText == null) {
            sizeStartText = "";
        }
        this.sizeStartText = sizeStartText;
    }

    protected void setSummaryObjectEndText(String summaryObjectEndText) {
        if (summaryObjectEndText == null) {
            summaryObjectEndText = "";
        }
        this.summaryObjectEndText = summaryObjectEndText;
    }

    protected void setSummaryObjectStartText(String summaryObjectStartText) {
        if (summaryObjectStartText == null) {
            summaryObjectStartText = "";
        }
        this.summaryObjectStartText = summaryObjectStartText;
    }

    protected void setUseClassName(boolean useClassName) {
        this.useClassName = useClassName;
    }

    protected void setUseFieldNames(boolean useFieldNames) {
        this.useFieldNames = useFieldNames;
    }

    protected void setUseIdentityHashCode(boolean useIdentityHashCode) {
        this.useIdentityHashCode = useIdentityHashCode;
    }

    protected void setUseShortClassName(boolean useShortClassName) {
        this.useShortClassName = useShortClassName;
    }

    private static final class DefaultToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        DefaultToStringStyle() {
        }

        private Object readResolve() {
            return DEFAULT_STYLE;
        }
    }

    private static final class MultiLineToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        MultiLineToStringStyle() {
            this.setContentStart("[");
            this.setFieldSeparator(System.lineSeparator() + "  ");
            this.setFieldSeparatorAtStart(true);
            this.setContentEnd(System.lineSeparator() + "]");
        }

        private Object readResolve() {
            return MULTI_LINE_STYLE;
        }
    }

    private static final class NoFieldNameToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        NoFieldNameToStringStyle() {
            this.setUseFieldNames(false);
        }

        private Object readResolve() {
            return NO_FIELD_NAMES_STYLE;
        }
    }

    private static final class ShortPrefixToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        ShortPrefixToStringStyle() {
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
        }

        private Object readResolve() {
            return SHORT_PREFIX_STYLE;
        }
    }

    private static final class SimpleToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        SimpleToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setUseFieldNames(false);
            this.setContentStart("");
            this.setContentEnd("");
        }

        private Object readResolve() {
            return SIMPLE_STYLE;
        }
    }

    private static final class NoClassNameToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        NoClassNameToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
        }

        private Object readResolve() {
            return NO_CLASS_NAME_STYLE;
        }
    }

    private static final class JsonToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_NAME_QUOTE = "\"";

        JsonToStringStyle() {
            this.setUseClassName(false);
            this.setUseIdentityHashCode(false);
            this.setContentStart("{");
            this.setContentEnd("}");
            this.setArrayStart("[");
            this.setArrayEnd("]");
            this.setFieldSeparator(",");
            this.setFieldNameValueSeparator(":");
            this.setNullText("null");
            this.setSummaryObjectStartText("\"<");
            this.setSummaryObjectEndText(">\"");
            this.setSizeStartText("\"<size=");
            this.setSizeEndText(">\"");
        }

        @Override
        public void append(StringBuffer buffer, String fieldName, boolean[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer, String fieldName, byte[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer, String fieldName, char[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer, String fieldName, double[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer, String fieldName, float[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer, String fieldName, int[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer, String fieldName, long[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer, String fieldName, Object value2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer, fieldName, value2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer, String fieldName, Object[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer, fieldName, array2, fullDetail);
        }

        @Override
        public void append(StringBuffer buffer, String fieldName, short[] array2, Boolean fullDetail) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            if (!this.isFullDetail(fullDetail)) {
                throw new UnsupportedOperationException("FullDetail must be true when using JsonToStringStyle");
            }
            super.append(buffer, fieldName, array2, fullDetail);
        }

        @Override
        protected void appendDetail(StringBuffer buffer, String fieldName, char value2) {
            this.appendValueAsString(buffer, String.valueOf(value2));
        }

        @Override
        protected void appendDetail(StringBuffer buffer, String fieldName, Collection<?> coll) {
            if (coll != null && !coll.isEmpty()) {
                buffer.append(this.getArrayStart());
                int i2 = 0;
                for (Object item : coll) {
                    this.appendDetail(buffer, fieldName, i2++, item);
                }
                buffer.append(this.getArrayEnd());
                return;
            }
            buffer.append(coll);
        }

        @Override
        protected void appendDetail(StringBuffer buffer, String fieldName, Map<?, ?> map2) {
            if (map2 != null && !map2.isEmpty()) {
                buffer.append(this.getContentStart());
                boolean firstItem = true;
                for (Map.Entry<?, ?> entry2 : map2.entrySet()) {
                    String keyStr = Objects.toString(entry2.getKey(), null);
                    if (keyStr == null) continue;
                    if (firstItem) {
                        firstItem = false;
                    } else {
                        this.appendFieldEnd(buffer, keyStr);
                    }
                    this.appendFieldStart(buffer, keyStr);
                    Object value2 = entry2.getValue();
                    if (value2 == null) {
                        this.appendNullText(buffer, keyStr);
                        continue;
                    }
                    this.appendInternal(buffer, keyStr, value2, true);
                }
                buffer.append(this.getContentEnd());
                return;
            }
            buffer.append(map2);
        }

        @Override
        protected void appendDetail(StringBuffer buffer, String fieldName, Object value2) {
            if (value2 == null) {
                this.appendNullText(buffer, fieldName);
                return;
            }
            if (value2 instanceof String || value2 instanceof Character) {
                this.appendValueAsString(buffer, value2.toString());
                return;
            }
            if (value2 instanceof Number || value2 instanceof Boolean) {
                buffer.append(value2);
                return;
            }
            String valueAsString = value2.toString();
            if (this.isJsonObject(valueAsString) || this.isJsonArray(valueAsString)) {
                buffer.append(value2);
                return;
            }
            this.appendDetail(buffer, fieldName, valueAsString);
        }

        @Override
        protected void appendFieldStart(StringBuffer buffer, String fieldName) {
            if (fieldName == null) {
                throw new UnsupportedOperationException("Field names are mandatory when using JsonToStringStyle");
            }
            super.appendFieldStart(buffer, FIELD_NAME_QUOTE + StringEscapeUtils.escapeJson(fieldName) + FIELD_NAME_QUOTE);
        }

        private void appendValueAsString(StringBuffer buffer, String value2) {
            buffer.append('\"').append(StringEscapeUtils.escapeJson(value2)).append('\"');
        }

        private boolean isJsonArray(String valueAsString) {
            return valueAsString.startsWith(this.getArrayStart()) && valueAsString.endsWith(this.getArrayEnd());
        }

        private boolean isJsonObject(String valueAsString) {
            return valueAsString.startsWith(this.getContentStart()) && valueAsString.endsWith(this.getContentEnd());
        }

        private Object readResolve() {
            return JSON_STYLE;
        }
    }
}

