/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.android;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.android.AndroidBootClasspathKt;
import org.jetbrains.kotlin.gradle.android.AndroidKotlinSourceSet;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinBinaryCoordinates;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinClasspath;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinClasspathKt;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinDependency;
import org.jetbrains.kotlin.gradle.idea.tcs.IdeaKotlinResolvedBinaryDependency;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.ide.IdeDependencyResolver;
import org.jetbrains.kotlin.tooling.core.ExtrasUtilsKt;
import org.jetbrains.kotlin.tooling.core.MutableExtras;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/android/AndroidBootClasspathIdeDependencyResolver;", "Lorg/jetbrains/kotlin/gradle/plugin/ide/IdeDependencyResolver;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "resolve", "", "Lorg/jetbrains/kotlin/gradle/idea/tcs/IdeaKotlinDependency;", "sourceSet", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "kotlin-gradle-plugin-tcs-android"})
public final class AndroidBootClasspathIdeDependencyResolver
implements IdeDependencyResolver {
    @NotNull
    private final Project project;

    public AndroidBootClasspathIdeDependencyResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public Set<IdeaKotlinDependency> resolve(@NotNull KotlinSourceSet sourceSet) {
        Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
        if (AndroidKotlinSourceSet.Companion.getAndroid(sourceSet) == null) {
            return SetsKt.emptySet();
        }
        Set set = AndroidBootClasspathKt.androidBootClasspath(this.project).getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.androidBootClasspath().files");
        IdeaKotlinClasspath ideaKotlinClasspath = IdeaKotlinClasspathKt.IdeaKotlinClasspath((Iterable)set);
        MutableExtras mutableExtras = ExtrasUtilsKt.mutableExtrasOf();
        IdeaKotlinBinaryCoordinates ideaKotlinBinaryCoordinates = new IdeaKotlinBinaryCoordinates("com.android", "sdk", "7.4", null, 8, null);
        return SetsKt.setOf((Object)new IdeaKotlinResolvedBinaryDependency("KOTLIN_COMPILE", ideaKotlinClasspath, ideaKotlinBinaryCoordinates, mutableExtras));
    }
}

